(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements double-precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  function vecnormlsup;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      if abs(r[i])>p then
        p := abs(r[i]);
    vecnormlsup := p;
  end; {supnorm}

  function vecnorml2;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + sqr(r[i]);
    vecnorml2 := sqrt(p);
  end; {l2norm}

  function spvecnorml2;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + sqr(r[pattern[i]]);
    spvecnorml2 := sqrt(p);
  end; {l2norm}

  function vecnorml1;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + abs(r[i]);
    vecnorml1 := p;
  end; {l1norm}

  function spvecnorml1;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + abs(r[pattern[i]]);
    spvecnorml1 := p;
  end; {l1norm}

  function vecnormlp;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + pow(abs(r[i]),VecLpNormExponent);
    vecnormlp := pow(p,1/VecLpNormExponent);
  end; {vecnormlp}

  function vecdistl1;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + abs(x[i]-y[i]);
    vecdistl1 := p;
  end; {diffl1norm}

  function vecdistl2;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + sqr(x[i]-y[i]);
    vecdistl2 := sqrt(p);
  end; {diffl2norm}

  function vecdistlp;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + pow(abs(x[i]-y[i]),VecLpNormExponent);
    vecdistlp := pow(p,1/VecLpNormExponent);
  end; {vecdistlp}

  function vecdistlsup;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := flmax(p,abs(x[i]-y[i]));
    vecdistlsup := p;
  end; {diffsupnorm}

  function vecsum;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + r[i];
    vecsum := p;
  end; {vecsum}

  function spvecsum;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + r[pattern[i]];
    spvecsum := p;
  end; {spvecsum}

  function vecdot;
  var
    i: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := dim0 to dim1 do
      a := a + p[i]*q[i];
    vecdot := a;
  end; {vecdot}

  function spvecdot;
  var
    i,j: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := 1 to dim do begin
      j := pattern[i];
      a := a + p[j]*q[j];
    end;
    spvecdot := a;
  end; {vecdot}

  procedure vectimes;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p[i]*q[i];
  end; {vectimes}

  procedure spvectimes;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[i] := p[j]*q[j];
    end;
  end; {vectimes}

  function vecsqr;
  var
    i: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := dim0 to dim1 do
      a := a + sqr(p[i]);
    vecsqr := a;
  end; {vecsqr}

  function spvecsqr;
  var
    i,j: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := 1 to dim do begin
      j := pattern[i];
      a := a + sqr(p[j]);
    end;
    spvecsqr := a;
  end; {spvecsqr}

  procedure vecaddc;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := a + x[i];
  end; {vecaddc}

  procedure spvecaddc;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := a + x[j];
    end;
  end; {vecaddc}

  procedure veczero;
  begin
    fillchar(x[dim0],(dim1-dim0+1)*sizeof(dFloat),0);
  end;

  procedure spveczero;
  var
    i: index;
  begin
    for i := 1 to dim do
      x[pattern[i]] := 0.0;
  end;

  function veccmpl1;
  var
    i: index;
    s: qFloat;
  begin
    i := dim0-1;
    s := 0.0;
    while (i<dim1) and (s<=threshold) do begin
      inc(i);
      s := s + abs(x[i]-y[i]);
    end;
    veccmpl1 := (s<=threshold);
  end; {veccmpl1}

  function veccmpl2;
  var
    i: index;
    s,t: qFloat;
  begin
    i := dim0-1;
    s := 0.0;
    t := sqr(threshold);
    while (i<dim1) and (s<=t) do begin
      inc(i);
      s := s + sqr(x[i]-y[i]);
    end;
    veccmpl2 := (s<=t);
  end; {veccmpl2}

  function veccmplsup;
  var
    i: index;
  begin
    i := dim0;
    while (i<=dim1) and (abs(x[i]-y[i])<=threshold) do
      inc(i);
    veccmplsup := (i>dim1);
  end; {veccmp}

  procedure spveccopy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      y[j] := x[j];
    end;
  end;

  procedure vecmcopy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      y[i] := -x[i];
  end;

  procedure spvecmcopy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      y[j] := -x[j];
    end;
  end;

  procedure vecadd;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := x[i] + y[i];
  end; {vecadd}

  procedure spvecadd;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := x[j] + y[j];
    end;
  end; {spvecaddxy}

  procedure vecpadd;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*(x[i] + y[i]);
  end; {vecpadd}

  procedure spvecpadd;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*(x[j] + y[j]);
    end;
  end; {spvecpadd}

  procedure vecsub;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := x[i] - y[i];
  end; {vecsub}

  procedure spvecsub;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := x[j] - y[j];
    end;
  end; {spvecsub}

  procedure vecpsub;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*(x[i] - y[i]);
  end; {vecpsub}

  procedure spvecpsub;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*(x[j] - y[j]);
    end;
  end; {spvecpsub}

  procedure vecaddpxy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*x[i] + y[i];
  end; {vecaddpxy}

  procedure spvecaddpxy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*x[j] + y[j];
    end;
  end; {spvecaddpxy}

  procedure vecsubpxy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*x[i] - y[i];
  end; {vecsubpxy}

  procedure spvecsubpxy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*x[j] - y[j];
    end;
  end; {spvecsubpxy}

  procedure vecaddpxqy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*x[i] + q*y[i];
  end; {vecaddxpy}

  procedure spvecaddpxqy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*x[j] + q*y[j];
    end;
  end; {spvecaddxpy}

  procedure vecscale;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := a*x[i];
  end; {vecscale}

  procedure spvecscale;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := a*x[j];
    end;
  end; {vecscale}

  procedure vecfill;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := c;
  end;

  procedure spvecfill;
  var
    i: index;
  begin
    for i := 1 to dim do
      r[pattern[i]] := c;
  end;

