(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements quadruple-precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

{$ifdef asm_math} {$i qvectors.asm} {$else} {$i qvectors.pp} {$endif}

  function spqVecnormlsup;
  var
    i,ii: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do begin
      ii := pattern[i];
      if abs(r[ii])>p then
        p := abs(r[ii]);
    end;
    spqVecnormlsup := p;
  end; {supnorm}

  function spqVecnormlp;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + pow(abs(r[pattern[i]]),VecLpNormExponent);
    spqVecnormlp := pow(p,1/VecLpNormExponent);
  end; {lpnorm}

  function qvecnormalize;
  var
    a: qFloat;
    i: index;
  begin
    a := qvecnorml2(dim0,dim1,x);
    for i := dim0 to dim1 do
      r[i] := a*x[i];
    qvecnormalize := a;
  end; {vecnormalize}

  function qveccmplp;
  var
    i: index;
    s,t: qFloat;
  begin
    i := dim0-1;
    s := 0.0;
    t := pow(threshold,VecLpNormExponent);
    while (i<dim1) and (s<=t) do begin
      inc(i);
      s := s + pow(abs(x[i]-y[i]),VecLpNormExponent);
    end;
    qveccmplp := (s<=t);
  end; {veccmplp}

  function spqVeccmp0;
  var
    i,ii: index;
  begin
    i := 0;
    ii := pattern[1];
    while (i<dim) and (x[ii]=y[ii]) do begin
      inc(i);
      ii := pattern[i+1];
    end;
    spqVeccmp0 := (i=dim);
  end; {spqVeccmp0}

  function spqVeccmpl1;
  var
    i,ii: index;
    s: qFloat;
  begin
    i := 0;
    s := 0.0;
    while (i<dim) and (s<=threshold) do begin
      inc(i);
      ii := pattern[i];
      s := s + abs(x[ii]-y[ii]);
    end;
    spqVeccmpl1 := (s<=threshold);
  end; {spqVeccmpl1}

  function spqVeccmpl2;
  var
    i,ii: index;
    s,t: qFloat;
  begin
    i := 0;
    s := 0.0;
    t := sqr(threshold);
    while (i<dim) and (s<=t) do begin
      inc(i);
    ii := pattern[i];
      s := s + sqr(x[ii]-y[ii]);
    end;
    spqVeccmpl2 := (s<=t);
  end; {spqVeccmpl2}

  function spqVeccmplp;
  var
    i,ii: index;
    s,t: qFloat;
  begin
    i := 0;
    s := 0.0;
    t := pow(threshold,VecLpNormExponent);
    while (i<dim) and (s<=t) do begin
      inc(i);
      ii := pattern[i];
      s := s + pow(abs(x[ii]-y[ii]),VecLpNormExponent);
    end;
    spqVeccmplp := (s<=t);
  end; {spqVeccmplp}

  function spqVeccmplsup;
  var
    i,ii: index;
    s: qFloat;
  begin
    i := 0;
    s := 0.0;
    while (i<dim) and (s<=threshold) do begin
      inc(i);
      ii := pattern[i];
      s := abs(x[ii]-y[ii]);
    end;
    spqVeccmplsup := (i=dim);
  end; {spqVeccmplsup}

  function qveccmp0;
  begin
    qveccmp0 := memcmp((dim1-dim0+1)*sizeof(qFloat),x[dim0],y[dim0]);
  end;

  procedure qveccopy;
  begin
    move(x[dim0],y[dim0],(dim1-dim0+1)*sizeof(qFloat));
  end;

  procedure qvecei;
  begin
    fillchar(r,dim*sizeof(qFloat),0);
    if (i<=dim) then r[i] := 1;
  end;

  procedure qvecenum;
  var
    i: index;
  begin
    r[dim0] := c0;
    for i := dim0+1 to dim1 do
      r[i] := r[i-1] + c;
  end;

  procedure spqVecenum;
  var
    i: index;
    x: qFloat;
  begin
    x := c0;
    r[pattern[1]] := c0;
    for i := 2 to dim do begin
      x := x + c;
      r[pattern[i]] := x;
    end;
  end;

  procedure qvectransform;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      y[i] := f(x[i],p);
  end; {vectransform}

  procedure spqVectransform;
  var
    i,ii: index;
  begin
    for i := 1 to dim do begin
      ii := pattern[i];
      y[ii] := f(x[ii],p);
    end;
  end; {vectransform}

  function qvecmax;
  var
    i: index;
    p: qFloat;
  begin
    p := r[dim0];
    for i := dim0+1 to dim1 do
      p := flmax(p,r[i]);
    qvecmax := p;
  end;

  function spqVecmax;
  var
    i: index;
    p: qFloat;
  begin
    p := r[pattern[1]];
    for i := 2 to dim do
      p := flmax(p,r[pattern[i]]);
    spqVecmax := p;
  end;

  function qvecmin;
  var
    i: index;
    p: qFloat;
  begin
    p := r[dim0];
    for i := dim0+1 to dim1 do
      p := flmin(p,r[i]);
    qvecmin := p;
  end;

  function spqVecmin;
  var
    i: index;
    p: qFloat;
  begin
    p := r[pattern[1]];
    for i := 2 to dim do
      p := flmin(p,r[pattern[i]]);
    spqVecmin := p;
  end;

  function qvecimax;
  var
    i: index;
    p: index;
    pp: qFloat;
  begin
    p := dim0;
    pp := r[p];
    for i := dim0+1 to dim1 do
      if (pp<r[i]) then begin p := i; pp := r[p]; end;
    qvecimax := p;
  end;

  function qvecimin;
  var
    i: index;
    p: index;
    pp: qFloat;
  begin
    p := dim0;
    pp := r[p];
    for i := dim0+1 to dim1 do
      if (pp>r[i]) then begin p := i; pp := r[p]; end;
    qvecimin := p;
  end;

  function qveciamax;
  var
    i: index;
    p: index;
    pp: qFloat;
  begin
    p := dim0;
    pp := abs(r[p]);
    for i := dim0+1 to dim1 do
      if pp<abs(r[i]) then begin p := i; pp := abs(r[p]); end;
    qveciamax := p;
  end;

  function qveciamin;
  var
    i: index;
    p: index;
    pp: qFloat;
  begin
    p := dim0;
    pp := abs(r[p]);
    for i := dim0+1 to dim1 do
      if pp>abs(r[i]) then begin p := i; pp := abs(r[p]); end;
    qveciamin := p;
  end;

  procedure qvecminmax;
  var
    i: index;
  begin
    min := r[dim0];
    max := r[dim0];
    for i := dim0+1 to dim1 do begin
      min := flmin(min,r[i]);
      max := flmax(max,r[i]);
    end;
  end;

  procedure spqVecminmax;
  var
    i,ii: index;
  begin
    ii := pattern[1];
    min := r[ii];
    max := r[ii];
    for i := 2 to dim do begin
      ii := pattern[i];
      min := flmin(min,r[ii]);
      max := flmax(max,r[ii]);
    end;
  end;

  function qvecalloc;
  begin
    if memoryAlloc(p,(dim1-dim0+1)*sizeof(qFloat)) then begin
      p := @p^[2-dim0];
      qveczero(dim0,dim1,p^);
      qvecalloc := true;
    end else
      qvecalloc := false;
  end; {qvecalloc}

  function qvecrealloc;
  begin
    if assigned(p) then p := @p^[dim0];
    if memoryReAlloc(p,(olddim1-dim0+1)*sizeof(qFloat),(newdim1-dim0+1)*sizeof(qFloat)) then begin
      p := @p^[2-dim0];
      qvecrealloc := true;
    end else
      qvecrealloc := false;
  end; {vecrealloc}

  procedure qvecfree;
  begin
    if assigned(p) then begin
      p := @p^[dim0];
      memoryDeAlloc(p,(dim1-dim0+1)*sizeof(qFloat));
    end;
  end; {vecfree}

  procedure qvecwrite;
  var
    i: index;
  begin
    writeln(f,dim1-dim0+1,' ',1,' '+msg);
    if (col=0) then begin {save row }
      for i := dim0 to dim1 do
        write(f,v[i],' ');
      writeln(f);
    end else { save column }
      for i := dim0 to dim1 do
        writeln(f,v[i]);
  end; {vecwrite}

  procedure spqvecwrite;
  var
    i: index;
  begin
    writeln(f,dim,' ',1,' '+msg);
    if (col=0) then begin {save row }
      for i := 1 to dim do
        write(f,v[pattern[i]],' ');
      writeln(f);
    end else { save column }
      for i := 1 to dim do
        writeln(f,v[pattern[i]]);
  end; {vecwrite}

  procedure qvecread;
  var
    i,j: index;
  begin
    readln(f); {this line contains qVector dimension}
    if (col=0) then begin { read current row }
      for i := dim0 to dim1 do
        read(f,v[i]);
      readln(f);
    end else begin  { read COL^th column }
      for i := dim0 to dim1 do begin
        for j := 1 to col do
          read(f,v[i]);
        readln(f);
      end;
    end;
  end; {vecread}

  procedure spqvecread;
  var
    i,j: index;
    r: qfloat;
  begin
    readln(f); {this line contains vector dimension}
    if (col=0) then begin { read current row }
      for i := 1 to dim do
        read(f,v[pattern[i]]);
      readln(f);
    end else begin  { read COL^th column }
      for i := 1 to dim do begin
        for j := 1 to col do
          read(f,r);
        v[pattern[i]] := r;
        readln(f);
      end;
    end;
  end; {vecread}

  function qvecsearch;
  var
    l,r: index;
  begin
    if (x0<=x[1]) then begin
      i := 1; d := 0.0;
      qvecsearch := (x0=x[1]);
    end else if (x0>=x[n]) then begin
      i := n; d := 0.0;
      qvecsearch := (x0=x[n]);
    end else begin
      qvecsearch := true;
      l := 1; r := n;
      while (r-l>1) do begin
        i := (l+r) div 2;
        if (x[i]<x0) then
          l := i
        else
          r := i;
      end;
      i := l;
      d := (x0-x[l])/(x[r]-x[l]);
    end;
  end; {vecsearch}

  function qvecsearchin;
  begin
    qvecsearchin := qvecsearch(n,x,x0,i,d);
    if (i=1) then
      d := (x0-x[1])/(x[2]-x[1])
    else if (i=n) then begin
      d := (x0-x[n-1])/(x[n]-x[n-1]);
      if (x0=x[n]) then dec(i);{!!!}
    end;
  end; {vecsearchin}

  procedure qvecqsort;
  var
    i,j: word;
    x,y: qFloat;
  begin
    i := il; j := ir; x := a[(il+ir)div 2];
    repeat
      while (a[i]<x) do inc(i);
      while (x<a[j]) do dec(j);
      if (i<=j) then begin
        if not (a[i]<a[j]) then
          qflswap(a[i],a[j]);
        inc(i);
        dec(j);
      end;
    until (i>j);
    if (il<j) then qvecqsort(il,j,a);
    if (i<ir) then qvecqsort(i,ir,a);
  end; {qsort}

  procedure qvechsort;
  var
    l,r,i,j: index;
    x: qFloat;
    ok: boolean;
    b: pqVector;
  begin

    { overlay new qvector over interval A[Il,Ir] }
    b := @a[il];
    ir := ir-il+1;
    il := 1;

    l := il+((ir-il+1) div 2);
    r := ir;
    ok := true;
    while ok do begin
      if (l>il) then begin
        dec(l);
        x := b^[l];
      end else begin
        x := b^[r];
        b^[r] := b^[il];
        dec(r);
        if (r=il) then begin
          b^[il] := x;
          ok := false;
        end;
      end;
      i := l;
      j := l+l;
      while (j<=r) do begin
        if (j<r) then
          if (b^[j]<b^[j+1]) then inc(j);
        if (x<b^[j]) then begin
          b^[i] := b^[j];
          i := j;
          j := j+j;
        end else
          j := r+1;
      end;
      b^[i] := x;
    end;
  end; {heapsort}

  procedure qvecswap;
  begin
    ptrswap(pointer(x),pointer(y));
  end;

  procedure qvecshift;
  var
    nn,n,i,j,jplus: integer;
    r: qfloat;
  begin
    nn := dim1-dim0+1;
    n := 0;
    i := dim0-1;
    while (n<nn) do begin
      inc(i);
      r := x[i];
      j := i;
      jplus := j-c;
      if (jplus>dim1) then jplus := jplus-nn
      else if (jplus<dim0) then jplus := jplus+nn;
      while (jplus<>i) do begin
        y[j] := x[jplus];
        inc(n);
        j := jplus;
        jplus := j-c;
        if (jplus>dim1) then jplus := jplus-nn
        else if (jplus<dim0) then jplus := jplus+nn;
      end;
      y[j] := r;
      inc(n);
    end;
  end; { vecshift }

  procedure qvecreflect;
  var
    i: index;
  begin
    if (@x=@y) then
      for i := 0 to (dim1-dim0) div 2 do
        qflswap(x[dim0+i], x[dim1-i])
    else
      for i := dim0 to dim1 do
        y[dim1-i+1] := x[i];
  end;


