(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements quad-precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  function qvecnormlsup;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      if abs(r[i])>p then
        p := abs(r[i]);
    qvecnormlsup := p;
  end; {supnorm}

  function qvecnorml2;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + sqr(r[i]);
    qvecnorml2 := sqrt(p);
  end; {l2norm}

  function spqVecnorml2;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + sqr(r[pattern[i]]);
    spqVecnorml2 := sqrt(p);
  end; {l2norm}

  function qvecnorml1;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + abs(r[i]);
    qvecnorml1 := p;
  end; {l1norm}

  function spqVecnorml1;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + abs(r[pattern[i]]);
    spqVecnorml1 := p;
  end; {l1norm}

  function qvecnormlp;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + pow(abs(r[i]),VecLpNormExponent);
    qvecnormlp := pow(p,1/VecLpNormExponent);
  end; {vecnormlp}

  function qvecdistl1;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + abs(x[i]-y[i]);
    qvecdistl1 := p;
  end; {diffl1norm}

  function qvecdistl2;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + sqr(x[i]-y[i]);
    qvecdistl2 := sqrt(p);
  end; {diffl2norm}

  function qvecdistlp;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + pow(abs(x[i]-y[i]),VecLpNormExponent);
    qvecdistlp := pow(p,1/VecLpNormExponent);
  end; {vecdistlp}

  function qvecdistlsup;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := flmax(p,abs(x[i]-y[i]));
    qvecdistlsup := p;
  end; {diffsupnorm}

  function qvecsum;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := dim0 to dim1 do
      p := p + r[i];
    qvecsum := p;
  end; {vecsum}

  function spqVecsum;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + r[pattern[i]];
    spqVecsum := p;
  end; {spqVecsum}

  function qvecdot;
  var
    i: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := dim0 to dim1 do
      a := a + p[i]*q[i];
    qvecdot := a;
  end; {vecdot}

  function spqVecdot;
  var
    i,j: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := 1 to dim do begin
      j := pattern[i];
      a := a + p[j]*q[j];
    end;
    spqVecdot := a;
  end; {vecdot}

  procedure qvectimes;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p[i]*q[i];
  end; {vectimes}

  procedure spqVectimes;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[i] := p[j]*q[j];
    end;
  end; {vectimes}

  function qvecsqr;
  var
    i: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := dim0 to dim1 do
      a := a + sqr(p[i]);
    qvecsqr := a;
  end; {vecsqr}

  function spqVecsqr;
  var
    i,j: index;
    a: qFloat;
  begin
    a := 0.0;
    for i := 1 to dim do begin
      j := pattern[i];
      a := a + sqr(p[j]);
    end;
    spqVecsqr := a;
  end; {spqVecsqr}

  procedure qvecfill;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := c;
  end;

  procedure qvecaddc;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := a + x[i];
  end; {vecaddc}

  procedure spqvecaddc;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := a + x[j];
    end;
  end; {vecaddc}

  procedure qveczero;
  begin
    fillchar(x[dim0],(dim1-dim0+1)*sizeof(qFloat),0);
  end;

  procedure spqVeczero;
  var
    i: index;
  begin
    for i := 1 to dim do
      x[pattern[i]] := 0.0;
  end;

  function qveccmpl1;
  var
    i: index;
    s: qFloat;
  begin
    i := dim0-1;
    s := 0.0;
    while (i<dim1) and (s<=threshold) do begin
      inc(i);
      s := s + abs(x[i]-y[i]);
    end;
    qveccmpl1 := (s<=threshold);
  end; {veccmpl1}

  function qveccmpl2;
  var
    i: index;
    s,t: qFloat;
  begin
    i := dim0-1;
    s := 0.0;
    t := sqr(threshold);
    while (i<dim1) and (s<=t) do begin
      inc(i);
      s := s + sqr(x[i]-y[i]);
    end;
    qveccmpl2 := (s<=t);
  end; {veccmpl2}

  function qveccmplsup;
  var
    i: index;
  begin
    i := dim0;
    while (i<=dim1) and (abs(x[i]-y[i])<=threshold) do
      inc(i);
    qveccmplsup := (i>dim1);
  end; {veccmp}

  procedure spqVeccopy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      y[j] := x[j];
    end;
  end;

  procedure qvecmcopy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      y[i] := -x[i];
  end;

  procedure spqVecmcopy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      y[j] := -x[j];
    end;
  end;

  procedure qvecadd;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := x[i] + y[i];
  end; {vecadd}

  procedure spqVecadd;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := x[j] + y[j];
    end;
  end; {spqVecaddxy}

  procedure qvecpadd;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*(x[i] + y[i]);
  end; {vecpadd}

  procedure spqVecpadd;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*(x[j] + y[j]);
    end;
  end; {spqVecpadd}

  procedure qvecsub;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := x[i] - y[i];
  end; {vecsub}

  procedure spqVecsub;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := x[j] - y[j];
    end;
  end; {spqVecsub}

  procedure qvecpsub;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*(x[i] - y[i]);
  end; {vecpsub}

  procedure spqVecpsub;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*(x[j] - y[j]);
    end;
  end; {spqVecpsub}

  procedure qvecaddpxy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*x[i] + y[i];
  end; {vecaddpxy}

  procedure spqVecaddpxy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*x[j] + y[j];
    end;
  end; {spqVecaddpxy}

  procedure qvecsubpxy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*x[i] - y[i];
  end; {vecsubpxy}

  procedure spqVecsubpxy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*x[j] - y[j];
    end;
  end; {spqVecsubpxy}

  procedure qvecaddpxqy;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := p*x[i] + q*y[i];
  end; {vecaddxpy}

  procedure spqVecaddpxqy;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := p*x[j] + q*y[j];
    end;
  end; {spqVecaddxpy}

  procedure qvecscale;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      r[i] := a*x[i];
  end; {vecscale}

  procedure spqVecscale;
  var
    i,j: index;
  begin
    for i := 1 to dim do begin
      j := pattern[i];
      r[j] := a*x[j];
    end;
  end; {vecscale}

  procedure spqVecfill;
  var
    i: index;
  begin
    for i := 1 to dim do
      r[pattern[i]] := c;
  end;


