(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements scalar math routines

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  { Invariant: Y >= 0 & Result*X**Y = X**I.  Init Y = I and Result = 1. }
  function ipow(X: Extended; I: Integer): Extended;
  var
    Y: Integer;
    P: Extended;
  begin
    Y := Abs(I);
    P := 1.0;
    while (Y>0) do begin
      while not Odd(Y) do
      begin
        Y := Y shr 1;
        X := X * X
      end;
      Dec(Y);
      P := P * X
    end;
    if (I>=0) then
      ipow := p
    else
      ipow := 1.0 / P;
  end;

  procedure imaxmin;
  begin
    if (x<y) then begin
      max := y;
      min := x;
    end else begin
      max := x;
      min := y;
    end;
  end;

  function pow;
  begin
    if (x>=macheps) then begin
      x := y*ln(x);
      pow := exp(x);
    end else
      pow := 0;
  end; {pow}

  function positive;
  begin
    if (x<=0) then positive := 0
    else positive := x;
  end; {positive}

  function imax;
  begin
    if (x<y) then imax := y else imax := x;
  end;

  function imin;
  begin
    if (x<y) then imin := x else imin := y;
  end;

  function flmax;
  begin
    if (x<y) then flmax := y else flmax := x;
  end;

  function flmin;
  begin
    if (x<y) then flmin := x else flmin := y;
  end;

  procedure flmaxmin;
  begin
    if (x<y) then begin
      max := y;
      min := x;
    end else begin
      max := x;
      min := y;
    end;
  end;

  function  v2absfl;
  begin
    v2absfl := sqrt(sqr(x) + sqr(y));
  end;

  function  v3absfl;
  begin
    v3absfl := sqrt(sqr(x) + sqr(y) + sqr(z));
  end;

  procedure flswap;
  var
    r: dfloat;
  begin
    r := x; x := y; y := r;
  end;

  procedure sflswap;
  var
    r: sfloat;
  begin
    r := x; x := y; y := r;
  end;

  procedure qflswap;
  var
    r: qfloat;
  begin
    r := x; x := y; y := r;
  end;

  procedure idxswap;
  var
    r: index;
  begin
    r := x; x := y; y := r;
  end;

  procedure intswap;
  var
    r: integer;
  begin
    r := x; x := y; y := r;
  end;

