(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements single precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

{$ifdef asm_math} {$i svectors.asm} {$else} {$i svectors.pp} {$endif}

  function svecalloc;
  begin
    if memoryAlloc(p,(dim1-dim0+1)*sizeof(sFloat)) then begin
      p := @p^[2-dim0];
      sveczero(dim0,dim1,p^);
      svecalloc := true;
    end else
      svecalloc := false;
  end; {svecalloc}

  function svecrealloc;
  begin
    if assigned(p) then p := @p^[dim0];
    if memoryReAlloc(p,(olddim1-dim0+1)*sizeof(sFloat),(newdim1-dim0+1)*sizeof(sFloat)) then begin
      p := @p^[2-dim0];
      svecrealloc := true;
    end else
      svecrealloc := false;
  end; {svecrealloc}

  procedure svecfree;
  begin
    if assigned(p) then begin
      p := @p^[dim0];
      memoryDeAlloc(p,(dim1-dim0+1)*sizeof(sFloat));
    end;
  end; {svecfree}

  procedure svecswap;
  begin
    ptrswap(pointer(x),pointer(y));
  end;

  procedure svecshift;
  var
    nn,n,i,j,jplus: integer;
    r: sfloat;
  begin
    nn := dim1-dim0+1;
    n := 0;
    i := dim0-1;
    while (n<nn) do begin
      inc(i);
      r := x[i];
      j := i;
      jplus := j-c;
      if (jplus>dim1) then jplus := jplus-nn
      else if (jplus<dim0) then jplus := jplus+nn;
      while (jplus<>i) do begin
        y[j] := x[jplus];
        inc(n);
        j := jplus;
        jplus := j-c;
        if (jplus>dim1) then jplus := jplus-nn
        else if (jplus<dim0) then jplus := jplus+nn;
      end;
      y[j] := r;
      inc(n);
    end;
  end; { vecshift }

  procedure svecreflect;
  var
    i: index;
  begin
    if (@x=@y) then
      for i := 0 to (dim1-dim0) div 2 do
        sflswap(x[dim0+i], x[dim1-i])
    else
      for i := dim0 to dim1 do
        y[dim1-i+1] := x[i];
  end;


