(*
FPU i87 implementation of vector operations
(C) Copyright 1997-2000 by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements vector data conversion

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)
(*
  Conversion routines for ?Vector data types
*)

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure dvec2qvec;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    PUSH    EAX
    MOV     EDX,dflsize
    MUL     EDX
    MOV     EBX,EAX
    POP     EAX
    MOV     EDX,qflsize
    MUL     EDX

    MOV     EDX, [DWORD PTR x]
    MOV     ECX, [DWORD PTR y]
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EBX]
    FSTP    TBYTE PTR [ECX + EAX]
    SUB     EAX,qflsize
    SUB     EBX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmdvec2qvec}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvec2dvec;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    PUSH    EAX
    MOV     EDX,dflsize
    MUL     EDX
    MOV     EBX,EAX
    POP     EAX
    MOV     EDX,qflsize
    MUL     EDX

    MOV     EDX, [DWORD PTR x]
    MOV     ECX, [DWORD PTR y]
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + EAX]
    FSTP    QWORD PTR [ECX + EBX]
    SUB     EAX,qflsize
    SUB     EBX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmdvec2qvec}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure dvec2svec;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    PUSH    EAX
    MOV     EDX,dflsize
    MUL     EDX
    MOV     EBX,EAX
    POP     EAX
    MOV     EDX,sflsize
    MUL     EDX

    MOV     EDX, [DWORD PTR x]
    MOV     ECX, [DWORD PTR y]
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EBX]
    FSTP    DWORD PTR [ECX + EAX]
    SUB     EAX,sflsize
    SUB     EBX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmdvec2qvec}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure svec2dvec;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    PUSH    EAX
    MOV     EDX,dflsize
    MUL     EDX
    MOV     EBX,EAX
    POP     EAX
    MOV     EDX,sflsize
    MUL     EDX

    MOV     EDX, [DWORD PTR x]
    MOV     ECX, [DWORD PTR y]
    JMP     @@?2

  @@?1:
    FLD     DWORD PTR [EDX + EAX]
    FSTP    QWORD PTR [ECX + EBX]
    SUB     EAX,sflsize
    SUB     EBX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmdvec2qvec}


