(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements double-precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

{$ifdef asm_math} {$i dvectors.asm} {$else} {$i dvectors.pp} {$endif}

  function spvecnormlsup;
  var
    i,ii: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do begin
      ii := pattern[i];
      if abs(r[ii])>p then
        p := abs(r[ii]);
    end;
    spvecnormlsup := p;
  end; {supnorm}

  function spvecnormlp;
  var
    i: index;
    p: qFloat;
  begin
    p := 0.0;
    for i := 1 to dim do
      p := p + pow(abs(r[pattern[i]]),VecLpNormExponent);
    spvecnormlp := pow(p,1/VecLpNormExponent);
  end; {lpnorm}

  function vecnormalize;
  var
    a: qFloat;
    i: index;
  begin
    a := vecnorml2(dim0,dim1,x);
    for i := dim0 to dim1 do
      r[i] := a*x[i];
    vecnormalize := a;
  end; {vecnormalize}

  function veccmplp;
  var
    i: index;
    s,t: qFloat;
  begin
    i := dim0-1;
    s := 0.0;
    t := pow(threshold,VecLpNormExponent);
    while (i<dim1) and (s<=t) do begin
      inc(i);
      s := s + pow(abs(x[i]-y[i]),VecLpNormExponent);
    end;
    veccmplp := (s<=t);
  end; {veccmplp}

  function spveccmp0;
  var
    i,ii: index;
  begin
    i := 0;
    ii := pattern[1];
    while (i<dim) and (x[ii]=y[ii]) do begin
      inc(i);
      ii := pattern[i+1];
    end;
    spveccmp0 := (i=dim);
  end; {spveccmp0}

  function spveccmpl1;
  var
    i,ii: index;
    s: qFloat;
  begin
    i := 0;
    s := 0.0;
    while (i<dim) and (s<=threshold) do begin
      inc(i);
      ii := pattern[i];
      s := s + abs(x[ii]-y[ii]);
    end;
    spveccmpl1 := (s<=threshold);
  end; {spveccmpl1}

  function spveccmpl2;
  var
    i,ii: index;
    s,t: qFloat;
  begin
    i := 0;
    s := 0.0;
    t := sqr(threshold);
    while (i<dim) and (s<=t) do begin
      inc(i);
    ii := pattern[i];
      s := s + sqr(x[ii]-y[ii]);
    end;
    spveccmpl2 := (s<=t);
  end; {spveccmpl2}

  function spveccmplp;
  var
    i,ii: index;
    s,t: qFloat;
  begin
    i := 0;
    s := 0.0;
    t := pow(threshold,VecLpNormExponent);
    while (i<dim) and (s<=t) do begin
      inc(i);
      ii := pattern[i];
      s := s + pow(abs(x[ii]-y[ii]),VecLpNormExponent);
    end;
    spveccmplp := (s<=t);
  end; {spveccmplp}

  function spveccmplsup;
  var
    i,ii: index;
    s: qFloat;
  begin
    i := 0;
    s := 0.0;
    while (i<dim) and (s<=threshold) do begin
      inc(i);
      ii := pattern[i];
      s := abs(x[ii]-y[ii]);
    end;
    spveccmplsup := (i=dim);
  end; {spveccmplsup}

  function veccmp0;
  begin
    veccmp0 := memcmp((dim1-dim0+1)*sizeof(dFloat),x[dim0],y[dim0]);
  end;

  procedure veccopy;
  begin
    move(x[dim0],y[dim0],(dim1-dim0+1)*sizeof(dFloat));
  end;

  procedure vecei;
  begin
    fillchar(r,dim*sizeof(dFloat),0);
    if (i<=dim) then r[i] := 1;
  end;

  procedure vecenum;
  var
    i: index;
  begin
    r[dim0] := c0;
    for i := dim0+1 to dim1 do
      r[i] := r[i-1] + c;
  end;

  procedure spvecenum;
  var
    i: index;
    x: dFloat;
  begin
    x := c0;
    r[pattern[1]] := c0;
    for i := 2 to dim do begin
      x := x + c;
      r[pattern[i]] := x;
    end;
  end;

  procedure vectransform;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      y[i] := f(x[i],p);
  end; {vectransform}

  procedure spvectransform;
  var
    i,ii: index;
  begin
    for i := 1 to dim do begin
      ii := pattern[i];
      y[ii] := f(x[ii],p);
    end;
  end; {vectransform}

  function vecmax;
  var
    i: index;
    p: dFloat;
  begin
    p := r[dim0];
    for i := dim0+1 to dim1 do
      p := flmax(p,r[i]);
    vecmax := p;
  end;

  function spvecmax;
  var
    i: index;
    p: dFloat;
  begin
    p := r[pattern[1]];
    for i := 2 to dim do
      p := flmax(p,r[pattern[i]]);
    spvecmax := p;
  end;

  function vecmin;
  var
    i: index;
    p: dFloat;
  begin
    p := r[dim0];
    for i := dim0+1 to dim1 do
      p := flmin(p,r[i]);
    vecmin := p;
  end;

  function spvecmin;
  var
    i: index;
    p: dFloat;
  begin
    p := r[pattern[1]];
    for i := 2 to dim do
      p := flmin(p,r[pattern[i]]);
    spvecmin := p;
  end;

  function vecimax;
  var
    i: index;
    p: index;
    pp: dFloat;
  begin
    p := dim0;
    pp := r[p];
    for i := dim0+1 to dim1 do
      if (pp<r[i]) then begin p := i; pp := r[p]; end;
    vecimax := p;
  end;

  function vecimin;
  var
    i: index;
    p: index;
    pp: dFloat;
  begin
    p := dim0;
    pp := r[p];
    for i := dim0+1 to dim1 do
      if (pp>r[i]) then begin p := i; pp := r[p]; end;
    vecimin := p;
  end;

  function veciamax;
  var
    i: index;
    p: index;
    pp: dFloat;
  begin
    p := dim0;
    pp := abs(r[p]);
    for i := dim0+1 to dim1 do
      if pp<abs(r[i]) then begin p := i; pp := abs(r[p]); end;
    veciamax := p;
  end;

  function veciamin;
  var
    i: index;
    p: index;
    pp: dFloat;
  begin
    p := dim0;
    pp := abs(r[p]);
    for i := dim0+1 to dim1 do
      if pp>abs(r[i]) then begin p := i; pp := abs(r[p]); end;
    veciamin := p;
  end;

  procedure vecminmax;
  var
    i: index;
  begin
    min := r[dim0];
    max := r[dim0];
    for i := dim0+1 to dim1 do begin
      min := flmin(min,r[i]);
      max := flmax(max,r[i]);
    end;
  end;

  procedure spvecminmax;
  var
    i,ii: index;
  begin
    ii := pattern[1];
    min := r[ii];
    max := r[ii];
    for i := 2 to dim do begin
      ii := pattern[i];
      min := flmin(min,r[ii]);
      max := flmax(max,r[ii]);
    end;
  end;

  function vecalloc;
  begin
    if memoryAlloc(p,(dim1-dim0+1)*sizeof(dFloat)) then begin
      p := @p^[2-dim0];
      veczero(dim0,dim1,p^);
      vecalloc := true;
    end else
      vecalloc := false;
  end; {vecalloc}

  function vecrealloc;
  begin
    if assigned(p) then p := @p^[dim0];
    if memoryReAlloc(p,(olddim1-dim0+1)*sizeof(dFloat),(newdim1-dim0+1)*sizeof(dFloat)) then begin
      p := @p^[2-dim0];
      vecrealloc := true;
    end else
      vecrealloc := false;
  end; {vecrealloc}

  procedure vecfree;
  begin
    if assigned(p) then begin
      p := @p^[dim0];
      memoryDeAlloc(p,(dim1-dim0+1)*sizeof(dFloat));
    end;
  end; {vecfree}

  procedure vecwrite;
  var
    i: index;
  begin
    writeln(f,dim1-dim0+1,' ',1,' '+msg);
    if (col=0) then begin {save row }
      for i := dim0 to dim1 do
        write(f,v[i],' ');
      writeln(f);
    end else { save column }
      for i := dim0 to dim1 do
        writeln(f,v[i]);
  end; {vecwrite}

  procedure spvecwrite;
  var
    i: index;
  begin
    writeln(f,dim,' ',1,' '+msg);
    if (col=0) then begin {save row }
      for i := 1 to dim do
        write(f,v[pattern[i]],' ');
      writeln(f);
    end else { save column }
      for i := 1 to dim do
        writeln(f,v[pattern[i]]);
  end; {vecwrite}

  procedure vecread;
  var
    i,j: index;
    r: dfloat;
  begin
    readln(f); {this line contains vector dimension}
    if (col=0) then begin { read current row }
      for i := dim0 to dim1 do
        read(f,v[i]);
      readln(f);
    end else begin  { read COL^th column }
      for i := dim0 to dim1 do begin
        for j := 1 to col do
          read(f,r);
        v[i] := r;
        readln(f);
      end;
    end;
  end; {vecread}

  procedure spvecread;
  var
    i,j: index;
    r: dfloat;
  begin
    readln(f); {this line contains vector dimension}
    if (col=0) then begin { read current row }
      for i := 1 to dim do
        read(f,v[pattern[i]]);
      readln(f);
    end else begin  { read COL^th column }
      for i := 1 to dim do begin
        for j := 1 to col do
          read(f,r);
        v[pattern[i]] := r;
        readln(f);
      end;
    end;
  end; {vecread}

  function vecsearch;
  var
    l,r: index;
  begin
    if (x0<=x[1]) then begin
      i := 1; d := 0.0;
      vecsearch := (x0=x[1]);
    end else if (x0>=x[n]) then begin
      i := n; d := 0.0;
      vecsearch := (x0=x[n]);
    end else begin
      vecsearch := true;
      l := 1; r := n;
      while (r-l>1) do begin
        i := (l+r) div 2;
        if (x[i]<x0) then
          l := i
        else
          r := i;
      end;
      i := l;
      d := (x0-x[l])/(x[r]-x[l]);
    end;
  end; {vecsearch}

  function vecsearchin;
  begin
    vecsearchin := vecsearch(n,x,x0,i,d);
    if (i=1) then begin
      if abs(x[1]-x[2])>not0 then
        d := (x0-x[1])/(x[2]-x[1])
      else
        d := 0.0;
    end else if (i=n) then begin
      if abs(x[n]-x[n-1])>not0 then
        d := (x0-x[n-1])/(x[n]-x[n-1])
      else d := 0.0;
      if (x0=x[n]) then dec(i);{!!!}
    end;
  end; {vecsearchin}

  function vecsearchlin;
  var
    j: index;
  begin
    j := dim0;
    while (j<=dim1) and (x[j]<>x0) do
      inc(j);
    if (j<=dim1) then begin
      i := j;
      vecsearchlin := true;
    end else
      vecsearchlin := false;
  end;

  function vecsearchlinapprox;
  var
    j: index;
  begin
    j := dim0;
    while (j<=dim1) and (abs(x[j]-x0)>tol) do
      inc(j);
    if (j<=dim1) then begin
      i := j;
      vecsearchlinapprox := true;
    end else
      vecsearchlinapprox := false;
  end;

  procedure vecqsort;
  var
    i,j: word;
    x,y: dFloat;
  begin
    i := il; j := ir; x := a[(il+ir)div 2];
    repeat
      while (a[i]<x) do inc(i);
      while (x<a[j]) do dec(j);
      if (i<=j) then begin
        if not (a[i]<a[j]) then
          flswap(a[i],a[j]);
        inc(i);
        dec(j);
      end;
    until (i>j);
    if (il<j) then vecqsort(il,j,a);
    if (i<ir) then vecqsort(i,ir,a);
  end; {qsort}

  procedure vechsort;
  var
    l,r,i,j: index;
    x: dFloat;
    ok: boolean;
    b: pdVector;
  begin

    { overlay new vector over interval A[Il,Ir] }
    b := @a[il];
    ir := ir-il+1;
    il := 1;

    l := il+((ir-il+1) div 2);
    r := ir;
    ok := true;
    while ok do begin
      if (l>il) then begin
        dec(l);
        x := b^[l];
      end else begin
        x := b^[r];
        b^[r] := b^[il];
        dec(r);
        if (r=il) then begin
          b^[il] := x;
          ok := false;
        end;
      end;
      i := l;
      j := l+l;
      while (j<=r) do begin
        if (j<r) then
          if (b^[j]<b^[j+1]) then inc(j);
        if (x<b^[j]) then begin
          b^[i] := b^[j];
          i := j;
          j := j+j;
        end else
          j := r+1;
      end;
      b^[i] := x;
    end;
  end; {heapsort}

  procedure vecswap;
  begin
    ptrswap(pointer(x),pointer(y));
  end;

  procedure vecshift;
  var
    nn,n,i,j,jplus: integer;
    r: dfloat;
  begin
    nn := dim1-dim0+1;
    n := 0;
    i := dim0-1;
    while (n<nn) do begin
      inc(i);
      r := x[i];
      j := i;
      jplus := j-c;
      if (jplus>dim1) then jplus := jplus-nn
      else if (jplus<dim0) then jplus := jplus+nn;
      while (jplus<>i) do begin
        y[j] := x[jplus];
        inc(n);
        j := jplus;
        jplus := j-c;
        if (jplus>dim1) then jplus := jplus-nn
        else if (jplus<dim0) then jplus := jplus+nn;
      end;
      y[j] := r;
      inc(n);
    end;
  end; { vecshift }

  procedure spvecshift;
  var
    n,i,j,jplus: integer;
    r: dfloat;
  begin
    n := 0;
    i := 0;
    while (n<dim) do begin
      inc(i);
      r := x[pattern[i]];
      j := i;
      jplus := j-c;
      if (jplus>dim) then jplus := jplus-dim
      else if (jplus<1) then jplus := jplus+dim;
      while (jplus<>i) do begin
        y[pattern[j]] := x[pattern[jplus]];
        inc(n);
        j := jplus;
        jplus := j-c;
        if (jplus>dim) then jplus := jplus-dim
        else if (jplus<1) then jplus := jplus+dim;
      end;
      y[pattern[j]] := r;
      inc(n);
    end;
  end; { vecshift }

  procedure vecreflect;
  var
    i: index;
  begin
    if (@x=@y) then
      for i := 0 to (dim1-dim0) div 2 do
        flswap(x[dim0+i], x[dim1-i])
    else
      for i := dim0 to dim1 do
        y[dim1-i+1] := x[i];
  end;


