(*
FPU i87 implementation of vector operations
(C) Copyright 1997-2000 by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements dynamic memory operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)
unit mops; { Memory operations }
interface
uses
  use32;

const

{$ifdef Use32}
  maxblock = $100000;      {size limited by 1 MB}
{$else}
  oneblock = 8;              {must be in DPMI}
  maxblock = 65536-oneblock; {max block size in 16-bit mode}
{$endif}

type
  sizetype = longint;

  function memoryalloc(var p; size: sizetype): boolean;
  procedure memorydealloc(var p; size: sizetype);

  {
    generally correct, but may cause memory fragmentation
  }
  function memoryrealloc(var p; oldsize,newsize: sizetype): boolean;

  procedure ptrswap(var a,b: pointer);

type
  plist = array[1..maxblock div sizeof(pointer)] of pointer;
  pplist = ^plist;

  function listalloc(dim: sizetype; var p: pplist): boolean;
  procedure listfree(dim: sizetype; var p: pplist);

  function memcmp(size: sizetype; var a,b): boolean;

  function memused: longint;
  function blockused: longint;

implementation
{$IFDEF VirtualPascal}
uses
  VPUtils;
{$ENDIF}

  {$ifdef dpmi}
  function kbsize(size: sizetype): sizetype;
  begin
    kbsize := (size div oneblock + byte(size mod oneblock > 0))*oneblock;
  end; {kbsize}
  {$endif}

const
  nhand: longint = 0; { handles being used up to now }
  ihand: longint = 0; { handles being currently in use }

  function memoryalloc;
  var
    pp: pointer absolute p;
  begin
    {$ifdef dpmi}
    size := kbsize(size);
    {$endif}
    if (size<=maxblock) and (pp=nil) and (maxavail>=size+sizeof(pointer)) then begin
      if (size>0) then begin
        getmem(pp,size);
        fillchar(pp^,size,0);
        inc(nhand);
        inc(ihand);
      end;
      memoryalloc := true;
    end else
      memoryalloc := false;
  end; {memoryalloc}

  procedure memorydealloc;
  var
    pp: pointer absolute p;
  begin
    if assigned(pp) and (size>0) then begin
    {$ifdef dpmi}
      freemem(pp,kbsize(size));
    {$else}
      freemem(pp,size);
    {$endif}
      dec(ihand);
      pp := nil;
    end;
  end; {memorydealloc}

  procedure ptrswap;
  var
    r: pointer;
  begin
    r := a;
    a := b;
    b := r;
  end; {ptrswap}

  function memoryrealloc;
  var
    pp: pointer absolute p;
    q: pointer;
  begin
    if (not assigned(pp)) then
      memoryrealloc := memoryalloc(pp,newsize)
    else if (newsize<>oldsize) then begin
      q := nil;
      if memoryalloc(q, newsize) then begin
        if (newsize>=oldsize) then
          newsize := oldsize;
        move(pp^,q^,newsize);
        memorydealloc(pp,oldsize);
        pp := q;
        memoryrealloc := true;
      end else
        memoryrealloc := false;
    end else
      memoryrealloc := true;
  end; {memoryrealloc}

  function listalloc;
  begin
    listalloc := memoryalloc(p,dim*sizeof(pointer));
  end;

  procedure listfree;
  begin
    memorydealloc(p,dim*sizeof(pointer));
  end;

  {$ifndef virtualpascal}
  var
    mem0: longint;
  function memused;
  begin
    memused := mem0 - memavail;
  end;
  {$else}
  function memused;
  begin
    memused := vputils.memused;
  end;
  {$endif}

{$ifdef asm_math} {$i memcmp.asm} {$else} {$i memcmp.pp} {$endif}

  function blockused;
  begin
    blockused := ihand;
  end;

begin
  {$ifndef virtualpascal}
  mem0 := memavail;
  {$endif}
end.


