(*
FPU i87 implementation of vector operations
(C) Copyright 1997-2000 by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements scalar math operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  {$USES EAX,EDX,ECX} {$SAVES EBX,EDI,ESI}
  function IPow;
  assembler;
  asm
          mov     eax, dword ptr i;
          mov     ecx, eax
          cdq
          fld1                      { Result := 1 }
          xor     eax, edx
          sub     eax, edx          { eax := Abs(Exponent) }
          jz      @@3
          fld     X
          jmp     @@2
  @@1:    fmul    ST, ST            { X := Base * Base }
  @@2:    shr     eax,1
          jnc     @@1
          fmul    ST(1),ST          { Result := Result * X }
          jnz     @@1
          fstp    st                { pop X from FPU stack }
          cmp     ecx, 0
          jge     @@3
          fld1
          fdivrp                    { Result := 1 / Result }
  @@3:
          fwait
  end;

  {$SAVES EBX,EDI,ESI}{$USES EAX,ECX,EDX}
  procedure imaxmin(const x,y: integer; var max,min: integer);
  assembler;
  asm
                  MOV     EAX,dword ptr x
                  MOV     ECX,dword ptr y
                  CMP     EAX,ECX
                  JGE     @@?2
                @@?1:
                  MOV     EDX,dword ptr max
                  MOV     [edx],ECX
                  MOV     EDX,dword ptr min
                  MOV     [edx],EAX
                  JMP     @@?3
                @@?2:
                  MOV     EDX,dword ptr max
                  MOV     [edx],EAX
                  MOV     EDX,dword ptr min
                  MOV     [edx],ECX
                @@?3:
  end;


function sign;
begin
  if (x>macheps) then sign := 1
  else if (x<-macheps) then sign := -1
  else sign:= 0;
end;
(*
{$ifndef __rtl_sign__} { otherwise it is inline macro defined in comp._\vp2\sign.inl }
  {$SAVES ALL} {$USES NONE}
   function sign;
   assembler;
   asm
{ if (x>macheps) then sign := 1 }
                FLD   QWORD PTR x
                FLD   TBYTE PTR macheps
                FCOM
                FNSTSW  AX
                SAHF
                JA     @@?2
              @@?1:
                MOV     AL,1
                JMP     @@?5
              @@?2:
{ else if (x<-macheps) then sign := -1 }
                FCHS
                FCOM
                FNSTSW  AX
                SAHF
                JBE     @@?4
              @@?3:
                MOV     AL,-1
                JMP     @@?5
              @@?4:
{ else sign := 0; }
                MOV     AL,0
              @@?5:
                fstp st(0)
                fstp st(0)
   end;
{$endif}
*)

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function pow;
  assembler;
  asm
    @@?0:
      FLD     TBYTE PTR [x]
      FLD     TBYTE PTR [macheps]
      FCOMP
      FNSTSW  AX
      SAHF
      JA      @@?2

    @@?1:
      CALL    System._Ln
      FLD     TBYTE PTR [y]
      FMULP   ST(1),ST(0)
      CALL    System._Exp
      JMP     @@?3

    @@?2:
      FLDZ
      FMULP

    @@?3:
  end; {asmpow}

  {$SAVES ALL} {$USES NONE}
  function positive;
  assembler;
  asm
                  FLDZ
                  FLD     TBYTE PTR x
                  FLD     ST(0)
                  FCOMP   ST(2)
                  FNSTSW  AX
                  SAHF
                  JA      @@?2
                @@?1:
                  FSTP    ST(0)
                  JMP     @@?3
                @@?2:
                  FADDP   ST(1),ST(0)
                @@?3:
  end; {asmpositive}

  {$SAVES EBX,EDX,ESI,EDI} {$USES ECX}
  function imax;
  assembler;
  asm
              MOV     EAX,[x]
              MOV     ECX,[y]
              CMP     EAX,ECX
              JGE     @@?2
            @@?1:
              MOV     EAX,ECX
            @@?2:
  end;

  {$SAVES EBX,EDX,ESI,EDI} {$USES ECX}
  function imin;
  assembler;
  asm
              MOV     EAX,[x]
              MOV     ECX,[y]
              CMP     EAX,ECX
              JLE     @@?2
            @@?1:
              MOV     EAX,ECX
            @@?2:
  end;

  {$SAVES ALL} {$USES NONE}
  function flmax;
  assembler;
  asm
                  FLD     QWORD PTR x
                  FLD     QWORD PTR y
                  FLD     ST(0)
                  FCOMP   ST(2)
                  FNSTSW  AX
                  SAHF
                  JAE     @@?2
                @@?1:
                  FSTP    ST(0)
                  JMP     @@?3
                @@?2:
                  FSTP
                @@?3:
  end;

  {$SAVES ALL} {$USES NONE}
  function flmin;
  assembler;
  asm
                  FLD     QWORD PTR x
                  FLD     QWORD PTR y
                  FLD     ST(0)
                  FCOMP   ST(2)
                  FNSTSW  AX
                  SAHF
                  JAE     @@?2
                @@?1:
                  FSTP
                  JMP     @@?3
                @@?2:
                  FSTP    ST(0)
                @@?3:
  end;

  {$SAVES EBX,ECX,EDX,EDI,ESI} {$USES EAX}
  procedure flmaxmin;
  assembler;
  asm
                  FLD     QWORD PTR x
                  FLD     QWORD PTR y
                  FLD     ST(0)
                  FCOMP   ST(2)
                  FNSTSW  AX
                  SAHF
                  JAE     @@?2
                @@?1:
                  MOV     eax,min
                  FSTP    QWORD PTR [eax]
                  MOV     eax,max
                  FSTP    QWORD PTR [eax]
                  JMP     @@?3
                @@?2:
                  MOV     eax,max
                  FSTP    QWORD PTR [eax]
                  MOV     eax,min
                  FSTP    QWORD PTR [eax]
                @@?3:
  end;

  {$SAVES EAX,EBX,ECX,EDX,ESI,EDI} {$USES NONE}
  function v2absfl;
  assembler;
  asm
    FLD     QWORD PTR x
    FMUL    ST(0),ST(0)
    FLD     QWORD PTR y
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FSQRT
  end; {asmv2absfl}

  {$SAVES EAX,EBX,ECX,EDX,ESI,EDI} {$USES NONE}
  function v3absfl;
  assembler;
  asm
    FLD     QWORD PTR x
    FMUL    ST(0),ST(0)
    FLD     QWORD PTR y
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FLD     QWORD PTR z
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FSQRT
  end; {asmv3absfl}

  {$SAVES EBX,ECX,EDI,ESI} {$USES EAX,EDX}
  procedure flswap;
  assembler;
  asm
    mov    eax,x;
    mov    edx,y;
    fld    qword ptr [eax];
    fld    qword ptr [edx];
    fstp   qword ptr [eax];
    fstp   qword ptr [edx];
  end; {asmflswap}

  {$SAVES EBX,ECX,EDI,ESI} {$USES EAX,EDX}
  procedure sflswap;
  assembler;
  asm
    mov    eax,x;
    mov    edx,y;
    fld    dword ptr [eax];
    fld    dword ptr [edx];
    fstp   dword ptr [eax];
    fstp   dword ptr [edx];
  end; {asmsflswap}

  {$SAVES EBX,ECX,EDI,ESI} {$USES EAX,EDX}
  procedure qflswap;
  assembler;
  asm
    mov    eax,x;
    mov    edx,y;
    fld    tbyte ptr [eax];
    fld    tbyte ptr [edx];
    fstp   tbyte ptr [eax];
    fstp   tbyte ptr [edx];
  end; {asmqflswap}

  {$SAVES EDI,ESI} {$USES EAX,EDX,EBX,ECX}
  procedure idxswap;
  assembler;
  asm
    mov    eax,x;
    mov    edx,y;
    mov    ebx,[eax];
    mov    ecx,[edx];
    mov    [eax],ecx;
    mov    [edx],ebx;
  end; {asmiswap}

  {$SAVES EDI,ESI} {$USES EAX,EDX,EBX,ECX}
  procedure intswap;
  assembler;
  asm
    mov    eax,x;
    mov    edx,y;
    mov    ebx,[eax];
    mov    ecx,[edx];
    mov    [eax],ecx;
    mov    [edx],ebx;
  end; {asmiswap}

