{
  2x2 vector and matrix operations
  3x3 vector and matrix operations
  386-asm optimised for DOUBLE vectors and DOUBLE scalars

  Tested with fPrint Virtual Pascal 2.0  (asm and pascal codes)
              Borland Pascal 7.0 and FPK (pascal code)

  (C) Copyright 1996-2000 by Jan Jeowicki,
      Department of Mathematics, Wrocaw University of Agriculture,
      jasj@karnet.ar.wroc.pl
      www.ar.wroc.pl/~jasj

  partially inspired with VMath10 by Wolfgang Lieff (c) 1991
                          Flinders Institute for Atmospheric and Marine Sciences
                          Bedford Park , South Australia 5042
                          mowl@cc.flinders.edu.au

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
}

{$i optimise.inc}
unit vec2;

interface

uses
  scalars , use32, mops;

type
  PVector2 = ^Vector2;
  Vector2 = array[xxx..yyy] of dFloat;
  PMatrix2 = ^Matrix2;
  Matrix2 = array[xxx..yyy] of Vector2;

type
  PVector3 = ^Vector3;
  Vector3 = array[xxx..zzz] of dFloat;
  PMatrix3 = ^Matrix3;
  Matrix3 = array[xxx..zzz] of Vector3;

type
  PVector4 = ^Vector4;
  Vector4 = array[xxx..ttt] of dFloat;
  PMatrix4 = ^Matrix4;
  Matrix4 = array[xxx..ttt] of Vector3;

type
  PIVector2 = ^IVector2;
  IVector2 = array[xxx..yyy] of integer;
  PIVector3 = ^IVector3;
  IVector3 = array[xxx..zzz] of integer;
  PIVector4 = ^IVector4;
  IVector4 = array[xxx..ttt] of integer;

  function iv2zero(var V: iVector2): PiVector2;
  function iv3zero(var V: iVector3): PiVector3;
  function iv4zero(var V: iVector4): PiVector4;

(* V2 operations *)

  { R = 0 }
  function v2zero(var V: Vector2): PVector2;
  { V1 ?= V2 }
  function v2eqzero(var V: Vector2): boolean;
  function v2equal(var V1,V2: Vector2): boolean;
  function v2cmp0(var x,y: vector2): boolean;
  function v2cmp(var x,y: vector2; const threshold: qFloat): boolean;
  { R = V }
  function v2copy(var V: Vector2; var R: Vector2): PVector2;
  { R = -V }
  function v2mcopy(var V: Vector2; var R: Vector2): PVector2;
  { R = x V }
  function v2scale(var V: Vector2; X: dFloat; var R: Vector2): PVector2;
  { R = (P2-P1)/|P2-P1|}
  function v2dir(var P1,P2: Vector2; var R: Vector2): PVector2;
  { R = V1 V2 componentwise }
  function v2mult(var V1,V2: Vector2; var R: Vector2): PVector2;
  { R = V1*V2 }
  function v2dot(var V1,V2: Vector2): qFloat;
  { R = V1 x V2 }
  function v2cross(var V1,V2: Vector2): qFloat;
  { R  V }
  function v2normalto(V: Vector2; var R: Vector2): PVector2;
  { R = V/|V|, @Result = |V| }
  function v2normalize(var V: Vector2; var R: Vector2): qFloat;
  { v2abs = |V| }
  function v2abs(var V: Vector2): qFloat;
  function v2sqr(var V: Vector2): qFloat;
  function v2absl1(var V: Vector2): qFloat;
  { R = V1/V2 componentwise }
  function v2div(var V1,V2: Vector2; var R: Vector2): PVector2;
  { R = x V1 + y V2 }
  function v2addpxqy(const x: dFloat; var V1: Vector2; const y: dFloat; var V2: Vector2; var R: Vector2): PVector2;
  { R = V1 + x V2 }
  function v2addxpy(var V1: Vector2; const x: dFloat; var V2: Vector2; var R: Vector2): PVector2;
  { R = V1 + V2 }
  function v2add(var V1,V2: Vector2; var R: Vector2): PVector2;
  { R = x (V1 + V2) }
  function v2padd(const x: dFloat; var V1,V2: Vector2; var R: Vector2): PVector2;
  { R = V + s }
  function v2shift(var V: Vector2; const s: dFloat; var R: Vector2): PVector2;
  { R = V1 - V2 }
  function v2sub(var V1,V2: Vector2; var R: Vector2): PVector2;
  { R = x (V1 - V2) }
  function v2psub(const x: dFloat; var V1,V2: Vector2; var R: Vector2): PVector2;
  { R = [x,y] }
  function FltoV2(const X,Y: dFloat; var V: Vector2): PVector2;
  { [x,y] = R }
  procedure V2toFl(var V: Vector2; var X,Y: dFloat);
  { |X-Y| }
  function v2dist(var X,Y: Vector2): qFloat;
  function v2distl1(var X,Y: Vector2): qFloat;
  { Y = X rotated in R basis }
  function v2rot(X,R: vector2; var Y: vector2): PVector2;
  { Y = X inversly rotated in R basis }
  function v2unrot(X,R: vector2; var Y: vector2): PVector2;

(* M2 operations *)

  { Y = M X }
  function M2TimesV2(var a: matrix2; var x,y: vector2): pvector2;
  { Y = X M }
  function M2TTimesV2(var a: matrix2; var x,y: vector2): pvector2;
  { M = a1 a2 }
  function M2TimesM2(var a1,a2,m: matrix2): pmatrix2;
  { M = M^T }
  procedure M2Tran(var a,b: matrix2);
  { B = A^(-1) }
  function M2Inv(var a: matrix2; var b: matrix2): boolean;
  { @ = |A| }
  function M2Det(var a: matrix2): qFloat;
  { X <-- solution, @ <-- exists }
  function M2Solve(var m: matrix2; var r,x: vector2): boolean;

(* V3 operations *)

  { R = 0 }
  function v3zero(var V: vector3): Pvector3;
  { V1 ?= V2 }
  function v3eqzero(var V: Vector3): boolean;
  function v3equal(var V1,V2: Vector3): boolean;
  function v3cmp0(var x,y: vector3): boolean;
  function v3cmp(var x,y: vector3; const threshold: qFloat): boolean;
  { R = V }
  function v3copy(var V: vector3; var R: vector3): Pvector3;
  { R = -V }
  function v3mcopy(var V: vector3; var R: vector3): Pvector3;
  { R = x V }
  function v3scale(var V: vector3; X: dFloat; var R: vector3): Pvector3;
  { R = (P2-P1)/|P2-P1|}
  function v3dir(var P1,P2: vector3; var R: vector3): Pvector3;
  { R = V1 V2 componentwise }
  function v3mult(var V1,V2: vector3; var R: vector3): Pvector3;
  { R = V1*V2 }
  function v3dot(var V1,V2: Vector3): qFloat;
  { R = V1 x V2 }
  function v3cross(var V1,V2,R: vector3): pvector3;
  { R = V/|V|, @Result = |V| }
  function v3normalize(var V: vector3; var R: vector3): qFloat;
  { v3abs = |V| }
  function v3abs(var V: vector3): qFloat;
  function v3sqr(var V: vector3): qFloat;
  function v3absl1(var V: vector3): qFloat;
  { R = V1/V2 componentwise }
  function v3div(var V1,V2: vector3; var R: vector3): Pvector3;
  { R = x V1 + y V2 }
  function v3addpxqy(const x: dFloat; var V1: vector3; const y: dFloat; var V2: vector3; var R: vector3): Pvector3;
  { R = V1 + x V2 }
  function v3addxpy(var V1: vector3; const x: dFloat; var V2: vector3; var R: vector3): Pvector3;
  { R = V1 + V2 }
  function v3add(var V1,V2: vector3; var R: vector3): Pvector3;
  { R = x (V1 + V2) }
  function v3padd(const x: dFloat; var V1,V2: vector3; var R: vector3): Pvector3;
  { R = V + s }
  function v3shift(var V: vector3; const s: dFloat; var R: vector3): Pvector3;
  { R = V1 - V2 }
  function v3sub(var V1,V2: vector3; var R: vector3): Pvector3;
  { R = x (V1 - V2) }
  function v3psub(const x: dFloat; var V1,V2: vector3; var R: vector3): Pvector3;
  { R = [x,y] }
  function FltoV3(const X,Y,Z: dFloat; var V: vector3): Pvector3;
  { [x,y] = R }
  procedure V3toFl(var V: vector3; var X,Y,Z: dFloat);
  { |X-Y| }
  function v3dist(var X,Y: vector3): qFloat;
  function v3distl1(var X,Y: vector3): qFloat;

(* M3 operations *)

  { Y = M X }
  function M3TimesV3(var a: matrix3; var x,y: vector3): pvector3;
  { Y = X M }
  function M3TTimesV3(var a: matrix3; var x,y: vector3): pvector3;
  { M = a1 a2 }
  function M3TimesM3(a1,a2: matrix3; var m: matrix3): pmatrix3;
  { M = M^T }
  procedure M3Tran(var a,b: matrix3);
  { B = A^(-1) }
  function M3Inv(var a: matrix3; var b: matrix3): boolean;
  { @ = |A| }
  function M3Det(var a: matrix3): qFloat;
  { X <-- solution, @ <-- exists }
  function M3Solve(var m: matrix3; var r,x: vector3): boolean;

  procedure m2zero(var m: Matrix2);
  procedure m3zero(var m: Matrix3);

  {
    @ <-- x0 \in Quadrilateral(x1,x2,x3,x4)
    starshape method
  }
  function xyinquad(var x0,x1,x2,x3,x4: vector2): boolean;
  function xyintriangle(var x0,x1,x2,x3: vector2): boolean;

const
  XVersor2: vector2 = (1.0, 0.0);
  YVersor2: vector2 = (0.0, 1.0);
  XVersor3: vector3 = (1.0, 0.0, 0.0);
  YVersor3: vector3 = (0.0, 1.0, 0.0);
  ZVersor3: vector3 = (0.0, 0.0, 1.0);

implementation

{$ifdef asm_math} {$i vec2.asm} {$else} {$i vec2.pp} {$endif}

  function iv2zero;
  begin
    fillchar(v,sizeof(vector2),0);
    iv2zero := @v;
  end;

  function iv3zero;
  begin
    fillchar(v,sizeof(vector3),0);
    iv3zero := @v;
  end;

  function iv4zero;
  begin
    fillchar(v,sizeof(vector4),0);
    iv4zero := @v;
  end;

  function v2dir;
  begin
    v2sub(p2,p1,r);
    v2normalize(r,r);
    v2dir := @r;
  end;

  function v2mult;
  begin
    r[xxx]:= v1[xxx] * v2[xxx];
    r[yyy]:= v1[yyy] * v2[yyy];
    v2mult := @r;
  end;

  function v2normalize;
  var
    l: qFloat;
  begin
    l := sqrt(sqr(v[xxx]) + sqr(v[yyy]));
    if l>0 then begin
      r[xxx]:= v[xxx]/l;
      r[yyy]:= v[yyy]/l;
    end else begin
      r[xxx]:= 0;
      r[yyy]:= 0;
    end;
    v2normalize := l;
  end;

  function v2div;
  begin
    r[xxx]:= v1[xxx]/v2[xxx];
    r[yyy]:= v1[yyy]/v2[yyy];
    v2div := @r;
  end;

  procedure V2toFl;
  begin
    x := v[xxx];
    y := v[yyy];
  end;
  function v2dist;
  begin
    v2dist := sqrt(sqr(x[xxx]-y[xxx]) + sqr(x[yyy]-y[yyy]));
  end;

  function v2distl1;
  begin
    v2distl1 := abs(x[xxx]-y[xxx]) + abs(x[yyy]-y[yyy]);
  end;

  function v2eqzero;
  begin
    v2eqzero := (v[xxx]=0.0) and (v[yyy]=0.0);
  end;

  function v2equal;
  begin
    v2equal := (v1[xxx]=v2[xxx]) and (v1[yyy]=v2[yyy]);
  end;

  function v2cmp0;
  begin
    v2cmp0 := memcmp(sizeof(vector2),x,y);
  end;

  function v2cmp;
  begin
    v2cmp := (v2dist(x,y)<threshold);
  end;

  function M2TimesV2;
  begin
    y[xxx] := v2dot(a[xxx],x);
    y[yyy] := v2dot(a[yyy],x);
    m2timesv2 := @y;
  end;

  function M2TTimesV2;
  begin
    y[xxx] := a[0,0]*x[0]+a[1,0]*x[1];
    y[yyy] := a[0,1]*x[0]+a[1,1]*x[1];
    m2ttimesv2 := @y;
  end;

  function M2TimesM2;
  var
    b: matrix2;
  begin
    M2TimesV2(a1,a2[0],b[0]);
    M2TimesV2(a1,a2[1],b[1]);
    M2Tran(b,m);
    M2TimesM2 := @m;
  end;

  procedure M2Tran;
  begin
    b := a;
    flswap(b[0,1],b[1,0]);
  end;

  function M2Det;
  begin
    m2det := a[0,0]*a[1,1] - a[1,0]*a[0,1];
  end;

  function M2Inv;
  var
    d,r: qFloat;
  begin
    d := a[0,0]*a[1,1] - a[1,0]*a[0,1];
    if (abs(d)>not0) then begin
      m2inv := true;
      b[1,0] := -a[1,0]/d;
      b[0,1] := -a[0,1]/d;
      r := a[0,0];
      b[0,0] := a[1,1]/d;
      b[1,1] := r/d;
    end else
      m2inv := false;
  end;

  function m2Solve;
  var
    d: qFloat;
  begin
    d := m[0,0]*m[1,1] - m[1,0]*m[0,1];
    if (abs(d)>not0) then begin
      x[0] := (r[0]*m[1,1] - r[1]*m[0,1])/d;
      x[1] := (m[0,0]*r[1] - m[1,0]*r[0])/d;
      m2solve := true;
    end else
      m2solve := false;
  end;

  function v3dir;
  begin
    v3sub(p2,p1,r);
    v3normalize(r,r);
    v3dir := @r;
  end;

  function v3mult;
  begin
    r[xxx]:= v1[xxx] * v2[xxx];
    r[yyy]:= v1[yyy] * v2[yyy];
    r[zzz]:= v1[zzz] * v2[zzz];
    v3mult := @r;
  end;

  function v3normalize;
  var
    l: qFloat;
  begin
    l := sqrt(sqr(v[xxx]) + sqr(v[yyy])+ sqr(v[zzz]));
    if (l>0) then begin
      r[xxx]:= v[xxx]/l;
      r[yyy]:= v[yyy]/l;
      r[zzz]:= v[zzz]/l;
    end else begin
      r[xxx]:= 0;
      r[yyy]:= 0;
      r[zzz]:= 0;
    end;
    v3normalize := l;
  end;

  function v3div;
  begin
    r[xxx]:= v1[xxx]/v2[xxx];
    r[yyy]:= v1[yyy]/v2[yyy];
    r[zzz]:= v1[zzz]/v2[zzz];
    v3div := @r;
  end;

  procedure v3toFl;
  begin
    x := v[xxx];
    y := v[yyy];
    z := v[zzz];
  end;

  function v3eqzero;
  begin
    v3eqzero := (v[xxx]=0.0) and (v[yyy]=0.0) and (v[zzz]=0.0);
  end;

  function v3equal;
  begin
    v3equal := (v1[xxx]=v2[xxx]) and (v1[yyy]=v2[yyy]) and (v1[zzz]=v2[zzz]);
  end;

  function v3cmp0;
  begin
    v3cmp0 := memcmp(sizeof(vector3),x,y);
  end;

  function v3cmp;
  begin
    v3cmp := (v3dist(x,y)<threshold);
  end;

  function v3dist;
  begin
    v3dist := sqrt(sqr(x[xxx]-y[xxx]) + sqr(x[yyy]-y[yyy]) + sqr(x[zzz]-y[zzz]));
  end;

  function v3distl1;
  begin
    v3distl1 := abs(x[xxx]-y[xxx]) + abs(x[yyy]-y[yyy]) + abs(x[zzz]-y[zzz]);
  end;

  function M3TimesV3;
  begin
    y[xxx] := v3dot(a[xxx],x);
    y[yyy] := v3dot(a[yyy],x);
    y[zzz] := v3dot(a[zzz],x);
    m3timesv3 := @y;
  end;

  function M3TTimesV3;
  begin
    y[xxx] := a[0,0]*x[0] + a[1,0]*x[1] + a[2,0]*x[2];
    y[yyy] := a[0,1]*x[0] + a[1,1]*x[1] + a[2,1]*x[2];
    y[zzz] := a[0,2]*x[0] + a[1,2]*x[1] + a[2,2]*x[2];
    m3ttimesv3 := @y;
  end;

  function M3TimesM3;
  begin
    m[0,0] := a1[0,0]*a2[0,0] + a1[0,1]*a2[1,0] + a1[0,2]*a2[2,0];
    m[0,1] := a1[0,0]*a2[0,1] + a1[0,1]*a2[1,1] + a1[0,2]*a2[2,1];
    m[0,2] := a1[0,0]*a2[0,2] + a1[0,1]*a2[1,2] + a1[0,2]*a2[2,2];
    m[1,0] := a1[1,0]*a2[0,0] + a1[1,1]*a2[1,0] + a1[1,2]*a2[2,0];
    m[1,1] := a1[1,0]*a2[0,1] + a1[1,1]*a2[1,1] + a1[1,2]*a2[2,1];
    m[1,2] := a1[1,0]*a2[0,2] + a1[1,1]*a2[1,2] + a1[1,2]*a2[2,2];
    m[2,0] := a1[2,0]*a2[0,0] + a1[2,1]*a2[1,0] + a1[2,2]*a2[2,0];
    m[2,1] := a1[2,0]*a2[0,1] + a1[2,1]*a2[1,1] + a1[2,2]*a2[2,1];
    m[2,2] := a1[2,0]*a2[0,2] + a1[2,1]*a2[1,2] + a1[2,2]*a2[2,2];
    M3TimesM3 := @m;
  end;

  procedure M3Tran;
  begin
    b := a;
    flswap(b[0,1],b[1,0]);
    flswap(b[0,2],b[2,0]);
    flswap(b[1,2],b[2,1]);
  end;

  function M3Det;
  begin
    m3det :=   a[0,0]*(a[1,1]*a[2,2] - a[1,2]*a[2,1])
             - a[0,1]*(a[1,0]*a[2,2] - a[1,2]*a[2,0])
             + a[0,2]*(a[1,0]*a[2,1] - a[1,1]*a[2,0]);
  end;

  function M3Inv;
  var
    d: qFloat;
  begin
    d := m3det(a);
    if (abs(d)>not0) then begin
      m3inv := true;
      b[0,0] := (a[1,1]*a[2,2] - a[1,2]*a[2,1])/d;
      b[1,0] := (a[1,2]*a[2,0] - a[1,0]*a[2,2])/d;
      b[2,0] := (a[1,0]*a[2,1] - a[1,1]*a[2,0])/d;
      b[0,1] := (a[0,2]*a[2,1] - a[0,1]*a[2,2])/d;
      b[1,1] := (a[0,0]*a[2,2] - a[0,2]*a[2,0])/d;
      b[2,1] := (a[0,1]*a[2,0] - a[0,0]*a[2,1])/d;
      b[0,2] := (a[1,2]*a[0,1] - a[1,1]*a[0,2])/d;
      b[1,2] := (a[1,0]*a[0,2] - a[1,2]*a[0,0])/d;
      b[2,2] := (a[1,1]*a[0,0] - a[1,0]*a[0,1])/d;
    end else
      m3inv := false;
  end;

  function m3Solve;
  var
    d: qFloat;
  begin
    d := m3det(m);
    if (abs(d)>not0) then begin
      x[0] := (  r[  0]*(m[1,1]*m[2,2]-m[1,2]*m[2,1])
               - m[0,1]*(r[  1]*m[2,2]-m[1,2]*m[2,0])
               + m[0,2]*(m[1,0]*m[2,1]-m[1,1]*r[  2]))/d;
      x[1] := (  m[0,0]*(r[  1]*m[2,2]-m[1,2]*m[2,1])
               - r[  0]*(m[1,0]*m[2,2]-m[1,2]*m[2,0])
               + m[0,2]*(m[1,0]*r[  2]-m[1,1]*m[2,0]))/d;
      x[2] := (  m[0,0]*(m[1,1]*m[2,2]-r[  1]*m[2,1])
               - m[0,1]*(m[1,0]*r[  2]-m[1,2]*m[2,0])
               + r[  0]*(m[1,0]*m[2,1]-m[1,1]*m[2,0]))/d;
      m3solve := true;
    end else
      m3solve := false;
  end;

  procedure m2zero;
  begin
    fillchar(m, sizeof(m), 0);
  end;

  procedure m3zero;
  begin
    fillchar(m, sizeof(m), 0);
  end;

  function xyinquad;
  var
    dd,dx: array[1..4] of vector2;
    r: array[1..4] of float;
    i: index;
  begin
    v2sub(x2,x1,dx[1]);
    v2sub(x3,x2,dx[2]);
    v2sub(x4,x3,dx[3]);
    v2sub(x1,x4,dx[4]);
    v2sub(x0,x1,dd[1]);
    v2sub(x0,x2,dd[2]);
    v2sub(x0,x3,dd[3]);
    v2sub(x0,x4,dd[4]);
    for i := 1 to 4 do begin
      r[i] := v2cross(dx[i],dd[i]);
    end;
    xyinquad := (r[1]*r[2]>=0) and (r[1]*r[3]>=0) and (r[1]*r[4]>=0);
  end; {xyinquad }

  function xyintriangle;
  var
    dd,dx: array[1..3] of vector2;
    r: array[1..3] of float;
    i: index;
  begin
    v2sub(x2,x1,dx[1]);
    v2sub(x3,x2,dx[2]);
    v2sub(x1,x3,dx[3]);
    v2sub(x0,x1,dd[1]);
    v2sub(x0,x2,dd[2]);
    v2sub(x0,x3,dd[3]);
    for i := 1 to 3 do begin
      r[i] := v2cross(dx[i],dd[i]);
    end;
    xyintriangle := (r[1]*r[2]>=0) and (r[1]*r[3]>=0);
  end; {xyintriangle }

end.

