(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)
{
  2x2 vector and matrix operations
  3x3 vector and matrix operations
  386-asm optimised for DOUBLE vectors and DOUBLE scalars

  Tested with fPrint Virtual Pascal 2.0 (asm and pascal codes)
              Borland Pascal 7.0 and FPK (pascal code)

  (c) Copyright 1996-2000 by Jan Jeowicki,
      Department of Mathematics, Wrocaw University of Agriculture, Poland
      jasj@karnet.ar.wroc.pl
      www.ar.wroc.pl/~jasj

  partially inspired with VMath10 by Wolfgang Lieff (c) 1991
                          Flinders Institute for Atmospheric and Marine Sciences
                          Bedford Park , South Australia 5042
                          mowl@cc.flinders.edu.au
}

  function v2zero;
  begin
    fillchar(v,sizeof(vector2),0);
    v2zero := @v;
  end;

  function v2copy;
  begin
    move(v,r,sizeof(vector2));
    v2copy := @r;
  end;

  function v2mcopy;
  begin
    r[xxx] := -v[xxx];
    r[yyy] := -v[yyy];
    v2mcopy := @r;
  end;

  function v2scale;
  begin
    r[xxx] := x*v[xxx];
    r[yyy] := x*v[yyy];
    v2scale := @r;
  end;

  function v2normalto;
  begin
    r[xxx] := v[yyy];
    r[yyy] := -v[xxx];
    v2normalto := @r;
  end;

  function  v2dot;
  begin
    v2dot := v1[xxx]*v2[xxx] + v1[yyy]*v2[yyy];
  end;

  function v2cross;
  begin
    v2cross := v1[yyy]*v2[xxx] - v1[xxx]*v2[yyy];
  end;

  function  v2abs;
  begin
    v2abs := sqrt(sqr(v[xxx]) + sqr(v[yyy]));
  end;

  function  v2absl1;
  begin
    v2absl1 := abs(v[xxx]) + abs(v[yyy]);
  end;

  function  v2sqr;
  begin
    v2sqr := sqr(v[xxx]) + sqr(v[yyy]);
  end;

  function v2addpxqy;
  begin
    r[xxx]:= x*v1[xxx] + y*v2[xxx];
    r[yyy]:= x*v1[yyy] + y*v2[yyy];
    v2addpxqy := @r;
  end;

  function v2padd;
  begin
    r[xxx]:= x*(v1[xxx] + v2[xxx]);
    r[yyy]:= x*(v1[yyy] + v2[yyy]);
    v2padd := @r;
  end;

  function v2psub;
  begin
    r[xxx]:= x*(v1[xxx] - v2[xxx]);
    r[yyy]:= x*(v1[yyy] - v2[yyy]);
    v2psub := @r;
  end;

  function v2addxpy;
  begin
    r[xxx]:= v1[xxx] + x*v2[xxx];
    r[yyy]:= v1[yyy] + x*v2[yyy];
    v2addxpy := @r;
  end;

  function v2add;
  begin
    r[xxx]:= v1[xxx] + v2[xxx];
    r[yyy]:= v1[yyy] + v2[yyy];
    v2add := @r;
  end;

  function v2shift;
  begin
    r[xxx]:= v[xxx] + s;
    r[yyy]:= v[yyy] + s;
    v2shift := @r;
  end;

  function v2sub;
  begin
    r[xxx]:= v1[xxx] - v2[xxx];
    r[yyy]:= v1[yyy] - v2[yyy];
    v2sub := @r;
  end;

  function FltoV2;
  begin
    v[xxx]:= x;
    v[yyy]:= y;
    FltoV2 := @v;
  end;

  function v2rot;
  begin
    y[xxx] := x[xxx]*r[xxx] + x[yyy]*r[yyy];
    y[yyy] := x[yyy]*r[xxx] - x[xxx]*r[yyy];
    v2rot := @y;
  end;

  function v2unrot;
  begin
    y[xxx] := x[xxx]*r[xxx] - x[yyy]*r[yyy];
    y[yyy] := x[yyy]*r[xxx] + x[xxx]*r[yyy];
    v2unrot := @y;
  end;

  function v3zero;
  begin
    fillchar(v,sizeof(vector3),0);
    v3zero := @v;
  end;

  function v3copy;
  begin
    move(v,r,sizeof(vector3));
    v3copy := @r;
  end;

  function v3mcopy;
  begin
    r[xxx] := -v[xxx];
    r[yyy] := -v[yyy];
    r[zzz] := -v[zzz];
    v3mcopy := @r;
  end;

  function v3scale;
  begin
    r[xxx] := x*v[xxx];
    r[yyy] := x*v[yyy];
    r[zzz] := x*v[zzz];
    v3scale := @r;
  end;

  function  v3dot;
  begin
    v3dot := v1[xxx]*v2[xxx] + v1[yyy]*v2[yyy] + v1[zzz]*v2[zzz];
  end;

  function v3cross;
  begin
    r[xxx] := v1[yyy]*v2[zzz] - v1[zzz]*v2[yyy];
    r[yyy] := v1[zzz]*v2[xxx] - v1[xxx]*v2[zzz];
    r[zzz] := v1[xxx]*v2[yyy] - v1[yyy]*v2[xxx];
    v3cross := @r;
  end;

  function  v3abs;
  begin
    v3abs := sqrt(sqr(v[xxx]) + sqr(v[yyy]) + sqr(v[zzz]));
  end;

  function  v3absl1;
  begin
    v3absl1 := abs(v[xxx]) + abs(v[yyy]) + abs(v[zzz]);
  end;

  function  v3sqr;
  begin
    v3sqr := sqr(v[xxx]) + sqr(v[yyy]) + sqr(v[zzz]);
  end;

  function v3addpxqy;
  begin
    r[xxx]:= x*v1[xxx] + y*v2[xxx];
    r[yyy]:= x*v1[yyy] + y*v2[yyy];
    r[zzz]:= x*v1[zzz] + y*v2[zzz];
    v3addpxqy := @r;
  end;

  function v3padd;
  begin
    r[xxx]:= x*(v1[xxx] + v2[xxx]);
    r[yyy]:= x*(v1[yyy] + v2[yyy]);
    r[zzz]:= x*(v1[zzz] + v2[zzz]);
    v3padd := @r;
  end;

  function v3psub;
  begin
    r[xxx]:= x*(v1[xxx] - v2[xxx]);
    r[yyy]:= x*(v1[yyy] - v2[yyy]);
    r[zzz]:= x*(v1[zzz] - v2[zzz]);
    v3psub := @r;
  end;

  function v3addxpy;
  begin
    r[xxx]:= v1[xxx] + x*v2[xxx];
    r[yyy]:= v1[yyy] + x*v2[yyy];
    r[zzz]:= v1[zzz] + x*v2[zzz];
    v3addxpy := @r;
  end;

  function v3add;
  begin
    r[xxx]:= v1[xxx] + v2[xxx];
    r[yyy]:= v1[yyy] + v2[yyy];
    r[zzz]:= v1[zzz] + v2[zzz];
    v3add := @r;
  end;

  function v3shift;
  begin
    r[xxx]:= v[xxx] + s;
    r[yyy]:= v[yyy] + s;
    r[zzz]:= v[zzz] + s;
    v3shift := @r;
  end;

  function v3sub;
  begin
    r[xxx]:= v1[xxx] - v2[xxx];
    r[yyy]:= v1[yyy] - v2[yyy];
    r[zzz]:= v1[zzz] - v2[zzz];
    v3sub := @r;
  end;

  function Fltov3;
  begin
    v[xxx]:= x;
    v[yyy]:= y;
    v[zzz]:= z;
    Fltov3 := @v;
  end;


