(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements Gaussian elimination for multidiagonal matrices
(there could be a great number of bugs...)

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  { Diag[acb] y = f }
  function diag3m;
  var
    i,i1: index;
    alpha,beta,
    aa,cc,ff: qFloat;
    ok: boolean;
  begin
    cc := c[1];
    ff := f[1];
    ok := (abs(cc)>not0);

    for i := 1 to dim-1 do begin
      i1 := i+1;
      aa := a[i1];
      if (ok) then begin
        alpha := -b[i]/cc; a[i] := alpha;
        beta := ff/cc;     b[i] := beta;
      end else begin
        diag3m := false;
        exit;
      end;
      cc := c[i1] + alpha*aa;
      ff := f[i1] - beta*aa;
      ok := (abs(cc)>not0);
    end;

    if (ok) then begin
      y[dim] := ff/cc;
      for i := dim-1 downto 1 do begin
        i1 := i+1;
        y[i] := a[i]*y[i1] + b[i];
      end;
    end;
    diag3m := ok;

  end; { diag3m }


  { Diag[acb] y = f }
  function diag3;
  var
    n, m, i, i1, i2 : index;
    arob,brob, bb,cc,aa,ff,phi: qFloat;
    kappa, theta: pivector; {macierze permutacji}
  begin
    theta := nil; kappa := nil;
    if ivalloc(1,dim,theta) and
       ivalloc(1,dim,kappa) then begin
    cc := c[1];
    aa := -a[2];
    ff := f[1];
    phi := f[2];
    kappa^[1] := 1;
    i1 := 1; i2 := 2;

    for i := 1 to dim-1 do begin
      inc(i1); inc(i2);
      bb := b[i];
      if abs(cc) >= abs(bb) then begin
        arob :=-bb/cc;
        brob := ff/cc;
        a[i] := arob;
        b[i] := brob;
        cc := c[i1] - aa*arob;
        ff := phi + aa*brob;
        theta^[i1] := kappa^[i];
        kappa^[i1] := i1;
        if i2<=dim then begin
          aa := -a[i2];
          phi := f[i2];
        end;
      end else begin
        arob := -cc/bb;  a[i] := arob;
        brob := ff/bb;   b[i] := brob;
        cc := c[i1]*arob - aa;
        ff := phi - c[i1]*brob;
        theta^[i1] := i1;
        kappa^[i1] := kappa^[i];
        if i2<=dim then begin
          aa := -a[i2]*arob;
          phi := f[i2] - a[i2]*brob;
        end;
      end;
    end;

    n := kappa^[dim];
    y[n] := ff/cc;
    for i := dim-1 downto 1 do begin
      i1 := i+1;
      m := theta^[i1];
      n := kappa^[i1];
      y[m] := a[i]*y[n] + b[i];
    end;
     diag3 := true;
   end else
     diag3 := false;
   ivfree(1,dim,kappa);
   ivfree(1,dim,theta);
  end; { diag3 }

  {           |.....B|
    Diag[acb]+|      | y = f , with Sherman-Morrison
              |A.....|                           }

  function diag3c;
  var
    gamma: dFloat;
    fact: qFloat;
    aa,bb,cc: pdVector;
    ok: boolean;
  begin
    if (dim>=3) then begin

      aa := nil;
      bb := nil;
      cc := nil;
      vecalloc(1,dim,aa);
      vecalloc(1,dim,bb);
      vecalloc(1,dim,cc);

      veccopy(1,dim,a,aa^);
      veccopy(1,dim,b,bb^);
      gamma := -c[1];
      c[1] := c[1]-gamma;
      c[dim] := c[dim] - alpha*beta/gamma;
      veccopy(1,dim,c,cc^);
      ok := diag3(dim,aa^,cc^,bb^,f,y);

      veczero(1,dim,aa^);
      aa^[1] := gamma;
      aa^[dim] := alpha;
      diag3c := ok and diag3(dim,a,c,b,aa^,bb^);
      fact := -(y[1] + beta*y[dim]/gamma) / (1.0 + bb^[1]+ beta*bb^[dim]/gamma);
      vecaddpxy(1,dim,fact,bb^,y,y);

      vecfree(1,dim,cc);
      vecfree(1,dim,bb);
      vecfree(1,dim,aa);

    end else

      diag3c := false;

  end; {diag3c}

  { Diag[abcde] y = f }
  function diag5;
  var
    i,i1,i2,i3,i4: index;
    max,gamma1,
    rob,arob,brob,crob,ee,
    cc,dd,ff, bb,qq,phi, ss,tt,gg, rr,aa,hh : qFloat;
    theta, kappa, eta: pivector;
  begin
    theta := nil; kappa := nil; eta := nil;
    if ivalloc(1,dim,theta) and
       ivalloc(1,dim,kappa) and
       ivalloc(1,dim,eta) then begin
    cc := c[1];   dd := -d[1];  ff := f[1];
    bb := -b[2];  qq := c[2];   phi := f[2];
    ss := a[3];   tt := -b[3];  gg := f[3];
    rr := 0.0;    aa := a[4];   hh := f[4];
    kappa^[1] := 1;  eta^[1] := 2;
    i1 := 1;  i2 := 2;  i3 := 3;  i4 := 4;

    for i := 1 to dim-2 do begin
      inc(i1);  inc(i2);  inc(i3);  inc(i4);
      ee := e[i];
      if abs(cc) < abs(dd) then max := abs(dd) else max := abs(cc);
      if max < abs(ee) then max := abs(ee);

      if max = abs(cc) then begin
        arob := dd/cc;    a[i] := arob;
        brob := ee/cc;  b[i] := brob;
        crob := ff/cc;    c[i] := crob;
        cc := qq-bb*arob;  dd := -d[i1]-bb*brob;  ff := phi+bb*crob;
        bb := tt-ss*arob;  qq := c[i2]-ss*brob;   phi := gg-ss*crob;
        if i2 < dim then begin
          ss := aa-rr*arob;  tt := -b[i3]-rr*brob;  gg := hh+rr*crob;
        end;
        if i3 < dim then begin
          rr := 0.0;  aa := a[i4];  hh := f[i4];
        end;
        theta^[i1] := kappa^[i];  kappa^[i1] := eta^[i];  eta^[i1] := i2;
      end else if max = abs(dd) then begin
        arob := cc/dd;    a[i] := arob;
        brob := -ee/dd; b[i] := brob;
        crob := -ff/dd;   c[i] := crob;
        cc := qq*arob-bb;  dd := qq*brob-d[i1];  ff := phi-qq*crob;
        bb := tt*arob-ss;  qq := tt*brob+c[i2];  phi := tt*crob+gg;
        if i2 < dim then begin
          ss := aa*arob-rr;  tt := aa*brob-b[i3];  gg := hh-aa*crob;
        end;
        if i3 < dim then begin
          rr := 0.0;  aa := a[i4];  hh := f[i4];
        end;
        theta^[i1] := eta^[i];  kappa^[i1] := kappa^[i];  eta^[i1] := i2;
      end else if max = abs(ee) then begin
        arob := dd/ee;         a[i] := arob;
        brob := cc/ee;        b[i] := brob;
        crob := ff/ee;        c[i] := crob;
        rob := d[i1];
        cc := qq+rob*arob;  dd := bb+rob*brob;  ff := phi-rob*crob;
        rob := c[i2];
        bb := tt-rob*arob;  qq := ss-rob*brob;  phi := gg-rob*crob;
        if i2 < dim then begin
          rob := b[i3];
          ss := aa+rob*arob;  tt := rr+rob*brob; gg := hh-rob*crob;
        end;
        if i3 < dim then begin
          rob := a[i4];
          rr := -rob*arob;  aa := -rob*brob;  hh := f[i4]-rob*crob;
        end;
        theta^[i1] := i2;  kappa^[i1] := eta^[i];  eta^[i1] := kappa^[i];
      end;
    end; {for i}

    i := dim-1;
    if abs(cc) >= abs(dd) then begin
      arob := dd/cc; a[i] := arob;
      crob := ff/cc; c[i] := crob;
      gamma1 := (phi+bb*crob)/(qq-bb*arob);
      theta^[dim] := kappa^[i];
      kappa^[dim] := eta^[i];
    end else begin
      arob := cc/dd; a[i] := arob;
      crob := -ff/dd; c[i] := crob;
      gamma1 := (phi-qq*crob)/(qq*arob-bb);
      theta^[dim] := eta^[i];
      kappa^[dim] := kappa^[i];
    end;

    i := kappa^[dim];
    y[i] := gamma1;
    y[theta^[dim]] := arob*y[i]+crob;

    for i := dim-2 downto 1 do begin
      i1 := i+1;
      y[theta^[i1]] := a[i]*y[kappa^[i1]] - b[i]*y[eta^[i1]] + c[i];
    end;
     diag5 := true;
   end else
     diag5 := false;
   ivfree(1,dim,eta);
   ivfree(1,dim,kappa);
   ivfree(1,dim,theta);
  end; { diag5 }

  { Diag[xabcdez] y = f }
  function diag7;
  var
    i1,i2,i3,i4,i5,i6,i: index;
    max, rob,arob,brob,crob,drob,delta1,zz,
    cc,dd,ee,ff,
    bb,qq,pp,phi,
    ss,tt,uu,gg,
    rr,aa,vv,hh,
    ll,mm,nn,jj,
    ww,xx,yy,kk : qFloat;
    theta,kappa,eta,zeta: pivector;
  begin
    theta := nil; kappa := nil; eta := nil; zeta := nil;
    if ivalloc(1,dim,theta) and
       ivalloc(1,dim,kappa) and
       ivalloc(1,dim,eta) and
       ivalloc(1,dim,zeta) then begin

    cc := c[1]; dd := d[1]; ee := e[1]; ff := f[1];
    bb := b[2]; qq := c[2]; pp := d[2]; phi := f[2];
    ss := a[3]; tt := b[3]; uu := c[3]; gg := f[3];
    rr := x[4]; aa := a[4]; vv := b[4]; hh := f[4];
    ll := 0.0;  mm := x[5]; nn := a[5]; jj := f[5];
    ww := 0.0;  xx := 0.0;  yy := x[6]; kk := f[6];
    kappa^[1] := 1;
    eta^[1] := 2;
    zeta^[1] := 3;
    i1 := 1; i2 := 2; i3 := 3; i4 := 4; i5 := 5; i6 := 6;

    for i := 1 to dim-3 do begin
      inc(i1); inc(i2); inc(i3); inc(i4); inc(i5); inc(i6);

      zz := z[i];
      if abs(cc) < abs(dd) then max := abs(dd) else max := abs(cc);
      if max < abs(ee) then max := abs(ee);
      if max < abs(zz) then max := abs(zz);

      if max=abs(cc) then begin
        arob := dd/cc;  a[i] := arob;
        brob := ee/cc;  b[i] := brob;
        crob := zz/cc;  c[i] := crob;
        drob := ff/cc;  d[i] := drob;
        cc := qq-bb*arob; dd := pp-bb*brob; ee := e[i1]-bb*crob; ff := phi-bb*drob;
        bb := tt-ss*arob; qq := uu-ss*brob; pp := d[i2]-ss*crob; phi:= gg-ss*drob;
        ss := aa-rr*arob; tt := vv-rr*brob; uu := c[i3]-rr*crob; gg := hh-rr*drob;
        if i3 < dim then begin
          rr := mm-ll*arob; aa := nn-ll*brob; vv := b[i4]-ll*crob;  hh := jj-ll*drob;
        end;
        if i4 < dim then begin
          ll := xx-ww*arob;  mm := yy-ww*brob;  nn := a[i5]-ww*crob;  jj := kk-ww*drob;
        end;
        if i5 < dim then begin
          ww := 0.0; xx := 0.0; yy := x[i6]; kk := f[i6];
        end;
        theta^[i1] := kappa^[i];
        kappa^[i1] := eta^[i]; eta^[i1] := zeta^[i]; zeta^[i1] := i3;
      end else if max=abs(dd) then begin
        arob := cc/dd;  a[i] := arob;
        brob := ee/dd;  b[i] := brob;
        crob := zz/dd;  c[i] := crob;
        drob := ff/dd;  d[i] := drob;
        cc := bb-qq*arob; dd := pp-qq*brob; ee := e[i1]-qq*crob; ff := phi-qq*drob;
        bb := ss-tt*arob; qq := uu-tt*brob; pp := d[i2]-tt*crob; phi := gg-tt*drob;
        ss := rr-aa*arob; tt := vv-aa*brob; uu := c[i3]-aa*crob; gg := hh-aa*drob;
        if i3 < dim then begin
          rr := ll-mm*arob; aa := nn-mm*brob; vv := b[i4]-mm*crob; hh := jj-mm*drob;
        end;
        if i4 < dim then begin
          ll := ww-xx*arob; mm := yy-xx*brob; nn := a[i5]-xx*crob; jj := kk-xx*drob;
        end;
        if i5 < dim then begin
          ww := 0.0; xx := 0.0; yy := x[i6]; kk := f[i6];
        end;
        theta^[i1] := eta^[i];
        kappa^[i1] := kappa^[i]; eta^[i1] := zeta^[i]; zeta^[i1] := i3;
      end else if max=abs(ee) then begin
        arob := dd/ee;  a[i] := arob;
        brob := cc/ee;  b[i] := brob;
        crob := zz/ee;  c[i] := crob;
        drob := ff/ee;  d[i] := drob;
        cc := qq-pp*arob; dd := bb-pp*brob; ee := e[i1]-pp*crob; ff := phi-pp*drob;
        bb := tt-uu*arob; qq := ss-uu*brob; pp := d[i2]-uu*crob; phi := gg-uu*drob;
        ss := aa-vv*arob; tt := rr-vv*brob; uu := c[i3]-vv*crob; gg := hh-vv*drob;
        if i3 < dim then begin
          rr := mm-nn*arob; aa := ll-nn*brob; vv := b[i4]-nn*crob; hh := jj-nn*drob;
        end;
        if i4 < dim then begin
          ll := xx-yy*arob; mm := ww-yy*brob; nn := a[i5]-yy*crob; jj := kk-yy*drob;
        end;
        if i5 < dim then begin
          ww := 0.0; xx := 0.0; yy := x[i6]; kk := f[i6];
        end;
        theta^[i1] := zeta^[i];
        kappa^[i1] := eta^[i]; eta^[i1] := kappa^[i]; zeta^[i1] := i3;
      end else if max=abs(zz) then begin
        arob := dd/zz;  a[i] := arob;
        brob := ee/zz;  b[i] := brob;
        crob := cc/zz;  c[i] := crob;
        drob := ff/zz;  d[i] := drob;
        rob := e[i1];
        cc := qq-rob*arob;  dd := pp-rob*brob;  ee := bb-rob*crob;  ff := phi-rob*drob;
        rob := d[i2];
        bb := tt-rob*arob;  qq := uu-rob*brob;  pp := ss-rob*crob;  phi := gg-rob*drob;
        rob := c[i3];
        ss := aa-rob*arob; tt := vv-rob*brob; uu := rr-rob*crob; gg := hh-rob*drob;
        if i3 < dim then begin
          rob := b[i4];
          rr := mm-rob*arob; aa := nn-rob*brob; vv := ll-rob*crob; hh := jj-rob*drob;
        end;
        if i4 < dim then begin
          rob := a[i5];
          ll := xx-rob*arob; mm := yy-rob*brob; nn := ww-rob*crob; jj := kk-rob*drob;
        end;
        if i5 < dim then begin
          rob := x[i6];
          ww := -rob*arob; xx := -rob*brob; yy := -rob*crob; kk := f[i6]-rob*drob;
        end;
        theta^[i1] := i3;
        kappa^[i1] := eta^[i]; eta^[i1]   := zeta^[i]; zeta^[i1]  := kappa^[i];
      end;
    end; {for i}

    {zwijanie macierzy 3x3:}
    i := dim-2;
    i1 := i+1;  i2 := i+2;
    if abs(cc) < abs(dd) then max := abs(dd) else max := abs(cc);
    if max < abs(ee) then max := abs(ee);

    if max=abs(cc) then begin
      arob := dd/cc;    a[i] := arob;
      brob := ee/cc;    b[i] := brob;
      drob := ff/cc;    d[i] := drob;
      cc := qq-bb*arob;  dd := pp-bb*brob;  ff := phi-bb*drob;
      bb := tt-ss*arob;  qq := uu-ss*brob;  phi := gg-ss*drob;
      theta^[i1] := kappa^[i];  kappa^[i1] := eta^[i];  eta^[i1] := zeta^[i];
    end else if max=abs(dd) then begin
      arob := cc/dd;    a[i] := arob;
      brob := ee/dd;    b[i] := brob;
      drob := ff/dd;    d[i] := drob;
      cc := bb-qq*arob;  dd := pp-qq*brob;  ff := phi-qq*drob;
      bb := ss-tt*arob;  qq := uu-tt*brob;  phi := gg-tt*drob;
      theta^[i1] := eta^[i];  kappa^[i1] := kappa^[i];  eta^[i1] := zeta^[i];
    end else if max = abs(ee) then begin
      arob := dd/ee;    a[i] := arob;
      brob := cc/ee;    b[i] := brob;
      drob := ff/ee;    d[i] := drob;
      cc := qq-pp*arob;  dd := bb-pp*brob;  ff := phi-pp*drob;
      bb := tt-uu*arob;  qq := ss-uu*brob;  phi := gg-uu*drob;
      theta^[i1] := zeta^[i];  kappa^[i1] := eta^[i];  eta^[i1] := kappa^[i];
    end;

    {zwijanie macierzy 2x2:}
    i := dim-1;
    if abs(cc)>=abs(dd) then begin
      arob := dd/cc; a[i] := arob;
      drob := ff/cc; d[i] := drob;
      delta1 := (phi-bb*drob)/(qq-bb*arob);
      theta^[dim] := kappa^[i];
      kappa^[dim] := eta^[i];
    end else begin
      arob := cc/dd; a[i] := arob;
      drob := ff/dd; d[i] := drob;
      delta1 := (phi-qq*drob)/(bb-qq*arob);
      theta^[dim] := eta^[i];
      kappa^[dim] := kappa^[i];
    end;

    {podstawianie:}
    i5 := kappa^[dim];
    i := dim-2;
    i1 := i+1;
    y[i5] := delta1;
    y[theta^[dim]] := -a[i1]*y[i5] + d[i1];
    y[theta^[i1]] := -a[i]*y[kappa^[i1]] - b[i]*y[eta^[i1]] + d[i];
    for i := dim-3 downto 1 do begin
      i1 := i+1;
      y[theta^[i1]] := -a[i]*y[kappa^[i1]] - b[i]*y[eta^[i1]] -
                        c[i]*y[zeta^[i1]] + d[i];
    end;

     diag7 := true;
   end else
     diag7 := false;
   ivfree(1,dim,zeta);
   ivfree(1,dim,eta);
   ivfree(1,dim,kappa);
   ivfree(1,dim,theta);
  end; { diag7 }


