(*
FPU i87 implementation of vector operations
(C) Copyright 1997-2000 by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements double-precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function vecnormlsup;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX
    MOV     ECX,EAX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + ECX]
    FABS
    FCOM   ST(1)
    FNSTSW  AX
    SAHF
    JAE     @@?3
    FSTP    ST(0)
    JMP     @@?4
  @@?3:
    FSTP    ST(1)
  @@?4:
    SUB     ECX,dflsize
  @@?2:
    CMP     ECX,0
    JGE     @@?1

  end; {asmsupnorm}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function vecnorml2;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EAX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSQRT
  end; {asml2norm}

  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spvecnorml2;
  assembler;
  asm

    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EDX, [DWORD PTR r]
    MOV     ECX, [DWORD PTR pattern]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [ECX+EAX]
    DEC     ESI
    FLD     QWORD PTR [EDX + ESI*dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,idxsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSQRT

  end; {asmspvecnorml2}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function vecnorml1;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EAX]
    FABS
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asml1norm}

  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spvecnorml1;
  assembler;
  asm

    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EDX, [DWORD PTR r]
    MOV     ECX, [DWORD PTR pattern]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [ECX+EAX]
    DEC     ESI
    FLD     QWORD PTR [EDX + ESI*dflsize]
    FABS
    FADDP   ST(1),ST(0)
    SUB     EAX,idxsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecnorml1}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,ECX,EDX}
  function vecnormlp;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX
    MOV     ECX,EAX;

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     VecLpNormExponent;
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + ECX]
    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?4;
    FABS;
    CALL    System._Ln;
    FMUL    ST(0),ST(2)
    CALL    System._Exp;
    FADDP   ST(1),ST(0)
    jmp @@?5
  @@?4:
    FSTP ST(0)
  @@?5:
    SUB     ECX,dflsize
  @@?2:
    CMP     ECX,0
    JGE     @@?1

    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?8;
    CALL    System._Ln;
    FLD1;
    FDIV    ST(0),ST(2);
    FMULP   ST(1),ST(0);
    CALL    System._Exp;
  @@?8:
    FSTP;
  end; {asmvecnormlp}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function vecdistl1;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     ECX, [DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR y]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FSUB    QWORD PTR [EDX + EAX]
    FABS
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmdiffl1norm}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function vecdistl2;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     ECX, [DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR y]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FSUB    QWORD PTR [EDX + EAX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSQRT
  end; {asmdiffl2norm}

  {$SAVES EBX,ESI,EDI} {$USES EAX,EDI,ECX,EDX}
  function vecdistlp;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX
    MOV     EDI,EAX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     ECX, [DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR y]
    ADD     EDX,EAX
    pop eax
    FLD     VecLpNormExponent;
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EDI]
    FSUB    QWORD PTR [EDX + EDI]
    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?4;
    FABS;
    CALL    System._Ln;
    FMUL    ST(0),ST(2)
    CALL    System._Exp;
    FADDP   ST(1),ST(0)
    JMP     @@?5
  @@?4:
    FSTP    ST(0)
  @@?5:
    SUB     EDI,dflsize
  @@?2:
    CMP     EDI,0
    JGE     @@?1

    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?8;
    CALL    System._Ln;
    FLD1;
    FDIV    ST(0),ST(2);
    FMULP   ST(1),ST(0);
    CALL    System._Exp;
  @@?8:
    FSTP;
  end; {asmvecdistlp}

  {$SAVES EBX,ESI} {$USES EAX,ECX,EDX,EDI}
  function vecdistlsup;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX
    MOV     ECX,EAX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR x]
    ADD     EDX,EAX
    MOV     EDI, [DWORD PTR y]
    ADD     EDI,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + ECX]
    FSUB    QWORD PTR [EDI + ECX]
    FABS
    FCOM    ST(1)
    FNSTSW  AX
    SAHF
    JAE     @@?3
    FSTP    ST(0)
    JMP     @@?4
  @@?3:
    FSTP    ST(1)
  @@?4:
    SUB     ECX,dflsize
  @@?2:
    CMP     ECX,0
    JGE     @@?1

  end; {asmvecdistlsup}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function vecsum;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EAX]
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecsum}

  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spvecsum;
  assembler;
  asm

    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EDX, [DWORD PTR r]
    MOV     ECX, [DWORD PTR pattern]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [ECX+EAX]
    DEC     ESI
    FLD     QWORD PTR [EDX + ESI*dflsize]
    FADDP   ST(1),ST(0)
    SUB     EAX,idxsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecsum}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function vecdot;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     ECX, [DWORD PTR p]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR q]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FMUL    QWORD PTR [EDX + EAX]
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecdot}

  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  function spvecdot;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR p]
    MOV     EDX,[DWORD PTR q]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDX + EBX*dflsize]
    FMUL    QWORD PTR [ECX + EBX*dflsize]
    FADDP   ST(1),ST(0)
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecdot}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vectimes;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX, [DWORD PTR r]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR p]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR q]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FMUL    QWORD PTR [EDX + EAX]
    FSTP    QWORD PTR [EBX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvectimes}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvectimes;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR p]
    MOV     EDX,[DWORD PTR q]
    MOV     EDI,[DWORD PTR r]
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDX + EBX*dflsize]
    FMUL    QWORD PTR [ECX + EBX*dflsize]
    FSTP    QWORD PTR [EDI + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvectimes}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function vecsqr;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR p]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EAX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecsqr}

  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spvecsqr;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR p]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     EDX, DWORD PTR [ESI + EAX]
    DEC     EDX
    FLD     QWORD PTR [ECX + EDX*dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecsqr}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure vecaddc;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    FLD     ST(0)
    FADD    QWORD PTR [ECX + EAX]
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecaddc}

  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spvecaddc;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [EBX + EAX]
    DEC     ESI
    FLD     ST(0)
    FADD    QWORD PTR [ECX + ESI*dflsize]
    FSTP    QWORD PTR [EDX + ESI*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecaddc}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  procedure veczero;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    FLDZ

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR x]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:

    FST     QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmveczero}

  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  procedure spveczero;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EDX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [EDX + EAX]
    DEC     ESI
    FST     QWORD PTR [ECX + ESI*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspveczero}

  {$SAVES EAX,EBX,ESI} {$USES ECX,EDX,ESI}
  function veccmpl1;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    INC     EAX;

    MOV     EDX,dflsize;
    MUL     EDX;
    MOV     ECX,EAX;
    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX,[x];
    ADD     EDX,EAX
    MOV     EDI,[y];
    ADD     EDI,EAX
    pop eax
    FLD     threshold;
    FLDZ
    XOR     EAX,EAX;
  @@?1:
    CMP     ECX,0
    JE      @@?4
  @@?2:
    FCOM    ST(1)
    FNSTSW  AX
    SAHF
    JAE      @@?4
  @@?3:
    SUB     ECX,dflsize

    FLD     QWORD PTR [EDX+ECX]
    FSUB    QWORD PTR [EDI+ECX]
    FABS
    FADDP   ST(1),ST(0)

    JMP     @@?1
  @@?4:
(*
    CMP     ECX,0
    SETE    AL
    FSTP
    FSTP    ST(0)
*)
    FCOMPP
    FNSTSW  AX
    SAHF
    SETBE AL
  end; {asmveccmpl1}

  {$SAVES EAX,EBX,ESI} {$USES ECX,EDX,ESI}
  function veccmpl2;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    INC     EAX;;
    MOV     EDX,dflsize;
    MUL     EDX;
    MOV     ECX,EAX;
    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX,[x];
    ADD     EDX,EAX
    MOV     EDI,[y];
    ADD     EDI,EAX
    pop eax
    FLD     threshold;
    FMUL    ST(0),ST(0)
    FLDZ
    XOR     EAX,EAX;
  @@?1:
    CMP     ECX,0
    JE      @@?4
  @@?2:
    FCOM   ST(1)
    FNSTSW  AX
    SAHF
    JAE      @@?4
  @@?3:
    SUB     ECX,dflsize

    FLD     QWORD PTR [EDX+ECX]
    FSUB    QWORD PTR [EDI+ECX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)

    JMP     @@?1
  @@?4:
(*
    CMP     ECX,0
    SETE    AL
    FSTP
    FSTP    ST(0)
*)
    FCOMPP
    FNSTSW  AX
    SAHF
    SETBE AL
  end; {asmveccmpl2}

  {$SAVES EAX,EBX,ESI} {$USES ECX,EDX,ESI}
  function veccmplsup;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    INC     EAX;
    MOV     EDX,dflsize;
    MUL     EDX;
    MOV     ECX,EAX;
    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX,[x];
    ADD     EDX,EAX
    MOV     EDI,[y];
    ADD     EDI,EAX
    pop eax
    FLD     threshold;
    XOR     EAX,EAX;
  @@?1:
    CMP     ECX,0
    JE      @@?4
  @@?3:
    SUB     ECX,dflsize

    FLD     QWORD PTR [EDX+ECX]
    FSUB    QWORD PTR [EDI+ECX]
    FABS
    FCOMP   ST(1)
    FNSTSW  AX
    SAHF
    JB      @@?1
    MOV     ECX,-1
  @@?4:
    CMP     ECX,0
    SETE    AL
    FSTP    ST(0)
  end; {veccmp}

  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spveccopy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     EDX,[DWORD PTR y]
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [EBX + EAX]
    DEC     ESI
    FLD     QWORD PTR [ECX + ESI*dflsize]
    FSTP    QWORD PTR [EDX + ESI*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspveccopy}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure vecmcopy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR x]
    ADD     EDX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EDX + EAX]
    FCHS
    FSTP    QWORD PTR [ECX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecmcopy}

  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spvecmcopy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     EDX,[DWORD PTR y]
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [EBX + EAX]
    DEC     ESI
    FLD     QWORD PTR [ECX + ESI*dflsize]
    FCHS
    FSTP    QWORD PTR [EDX + ESI*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecmcopy}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecadd;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FADD    QWORD PTR [EBX + EAX]
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecadd}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecadd;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FADD    QWORD PTR [ECX + EBX*dflsize]
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecadd}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecpadd;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p;
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FADD    QWORD PTR [EBX + EAX]
    FMUL    ST(0),ST(1)
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecpadd}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecpadd;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FADD    QWORD PTR [ECX + EBX*dflsize]
    FMUL    ST(0),ST(1)
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecpadd}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecsub;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD      QWORD PTR [EBX + EAX]
    FSUB     QWORD PTR [ECX + EAX]
    FSTP     QWORD PTR [EDX + EAX]
    SUB      EAX,dflsize
  @@?2:
    CMP      EAX,0
    JGE      @@?1

  end; {asmvecsub}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecsub;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FSUB    QWORD PTR [ECX + EBX*dflsize]
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspvecsub}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecpsub;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p;
    JMP     @@?2

  @@?1:
    FLD      QWORD PTR [EBX + EAX]
    FSUB     QWORD PTR [ECX + EAX]
    FMUL     ST(0),ST(1)
    FSTP     QWORD PTR [EDX + EAX]
    SUB      EAX,dflsize
  @@?2:
    CMP      EAX,0
    JGE      @@?1

    FSTP     ST(0)

  end; {asmvecpsub}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecpsub;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FSUB    QWORD PTR [ECX + EBX*dflsize]
    FMUL    ST(0),ST(1)
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    POP     EAX
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecpsub}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecaddpxy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX,[DWORD PTR y]
    ADD     EBX,EAX
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FMUL    ST(0),ST(1)
    FADD    QWORD PTR [EBX + EAX]
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecaddpxy}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecaddpxy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FMUL    ST(0),ST(1)
    FADD    QWORD PTR [ECX + EBX*dflsize]
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecaddpxy}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecsubpxy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX,[DWORD PTR y]
    ADD     EBX,EAX
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FMUL    ST(0),ST(1)
    FSUB    QWORD PTR [EBX + EAX]
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecsubpxy}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecsubpxy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FMUL    ST(0),ST(1)
    FSUB    QWORD PTR [ECX + EBX*dflsize]
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecsubpxy}

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure vecaddpxqy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p
    FLD     TBYTE PTR q
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [EBX + EAX]
    FMUL    ST(0),ST(2)
    FLD     QWORD PTR [ECX + EAX]
    FMUL    ST(0),ST(2)
    FADDP   ST(1),ST(0)
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)
    FSTP    ST(0)

  end; {asmvecaddpxqy}

  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spvecaddpxqy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR p
    FLD     TBYTE PTR q
    JMP     @@?2

  @@?1:
    MOV     EBX, DWORD PTR [ESI + EAX]
    DEC     EBX
    FLD     QWORD PTR [EDI + EBX*dflsize]
    FMUL    ST(0),ST(2)
    FLD     QWORD PTR [ECX + EBX*dflsize]
    FMUL    ST(0),ST(2)
    FADDP   ST(1),ST(0)
    FSTP    QWORD PTR [EDX + EBX*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP
    FSTP    ST(0)

  end; {asmspvecsubpxy}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure vecscale;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    FLD     QWORD PTR [ECX + EAX]
    FMUL    ST(0),ST(1)
    FSTP    QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecscale}

  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spvecscale;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     EDX,[DWORD PTR r]
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [EBX + EAX]
    DEC     ESI
    FLD     QWORD PTR [ECX + ESI*dflsize]
    FMUL    ST(0),ST(1)
    FSTP    QWORD PTR [EDX + ESI*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecscale}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure vecfill;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,dflsize
    MUL     EDX

    FLD     TBYTE PTR c

    push eax
    mov eax,dim0
    dec eax
    mov edx,flsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:

    FST     QWORD PTR [EDX + EAX]
    SUB     EAX,dflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecfill}

  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  procedure spvecfill;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EDX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR r]
    FLD     TBYTE PTR c
    JMP     @@?2

  @@?1:
    MOV     ESI, DWORD PTR [EDX + EAX]
    DEC     ESI
    FST     QWORD PTR [ECX + ESI*dflsize]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspvecfill}


