(*
FPU i87 implementation of vector operations
(C) Copyright by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements integer-valued vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  function ivalloc;
  begin
    if memoryAlloc(p,(dim1-dim0+1)*sizeof(index)) then begin
      ivalloc := true;
      p := @p^[2-dim0];
    end else
      ivalloc := false;
  end; {ivalloc}

  function ivrealloc;
  begin
    if assigned(p) then p := @p^[dim0];
    if memoryReAlloc(p,(olddim1-dim0+1)*sizeof(index),(newdim1-dim0+1)*sizeof(index)) then begin
      ivrealloc := true;
      p := @p^[2-dim0];
    end else
      ivrealloc := false;
  end; {ivrealloc}

  procedure ivfree;
  begin
    if assigned(p) then begin
      p := @p^[dim0];
      memoryDeAlloc(p,(dim1-dim0+1)*sizeof(index));
    end;
  end; {vecfree}

  procedure ivzero;
  begin
    fillchar(p,(dim1-dim0+1)*sizeof(index),0);
  end; {ivzero}

  procedure ivfill;
  var
    i: index;
  begin
    for i := dim0 to dim1 do
      p[i] := c;
  end; {ivfill}

  procedure ivcopy;
  begin
    move(p[dim0],q[dim0],(dim1-dim0+1)*sizeof(index));
  end; {ivcopy}

  function ivecimax;
  var
    i: index;
    p: index;
    pp: index;
  begin
    p := dim0;
    pp := r[p];
    for i := dim0+1 to dim1 do
      if (pp<r[i]) then begin p := i; pp := r[p]; end;
    ivecimax := p;
  end;

  function ivecimin;
  var
    i: index;
    p: index;
    pp: index;
  begin
    p := dim0;
    pp := r[p];
    for i := dim0+1 to dim1 do
      if (pp>r[i]) then begin p := i; pp := r[p]; end;
    ivecimin := p;
  end;

  function ivecmin;
  var
    i: index;
    p: index;
  begin
    p := r[dim0];
    for i := dim0+1 to dim1 do
      p := imin(p,r[i]);
    ivecmin := p;
  end;

  function ivecmax;
  var
    i: index;
    p: index;
  begin
    p := r[dim0];
    for i := dim0+1 to dim1 do
      p := imax(p,r[i]);
    ivecmax := p;
  end;

  procedure ivecminmax;
  var
    i: index;
  begin
    min := r[dim0];
    max := r[dim0];
    for i := dim0+1 to dim1 do begin
      min := imin(min,r[i]);
      max := imax(max,r[i]);
    end;
  end;

  function iveciamax;
  var
    i: index;
    p: index;
    pp: index;
  begin
    p := dim0;
    pp := abs(r[p]);
    for i := dim0+1 to dim1 do
      if pp<abs(r[i]) then begin p := i; pp := abs(r[p]); end;
    iveciamax := p;
  end;

  function iveciamin;
  var
    i: index;
    p: index;
    pp: index;
  begin
    p := dim0;
    pp := abs(r[p]);
    for i := dim0+1 to dim1 do
      if pp>abs(r[i]) then begin p := i; pp := abs(r[p]); end;
    iveciamin := p;
  end;

  procedure ivecshift;
  var
    nn,n,i,j,jplus: integer;
    r: index;
  begin
    nn := dim1-dim0+1;
    n := 0;
    i := dim0-1;
    while (n<nn) do begin
      inc(i);
      r := x[i];
      j := i;
      jplus := j-c;
      if (jplus>dim1) then jplus := jplus-nn
      else if (jplus<dim0) then jplus := jplus+nn;
      while (jplus<>i) do begin
        y[j] := x[jplus];
        inc(n);
        j := jplus;
        jplus := j-c;
        if (jplus>dim1) then jplus := jplus-nn
        else if (jplus<dim0) then jplus := jplus+nn;
      end;
      y[j] := r;
      inc(n);
    end;
  end; { ivecshift }

  function aivalloc;
  begin
    if memoryAlloc(p,(dim+2)*sizeof(index)+sizeof(boolean)) then with p^ do begin
      allocdimen := dim;
      dimen := dim;
      aivzero(p^);
      aivalloc := true;
      valid := true;
    end else
      aivalloc := false;
  end; {aivalloc}

  function aivrealloc;
  begin
    if assigned(p) then begin
      if memoryReAlloc(p,(p^.allocdimen+2)*sizeof(index)+sizeof(boolean),
                            (dim1+2)*sizeof(index)+sizeof(boolean)) then with p^ do begin
        allocdimen := dim1;
        dimen := imin(dim1,dimen);
        aivrealloc := true;
        valid := true;
      end else
        aivrealloc := false;
    end else
      aivrealloc := aivalloc(dim1,p);
  end; {aivrealloc}

  procedure aivfree;
  begin
    if assigned(p) then
      memoryDeAlloc(p,(p^.allocdimen+2)*sizeof(index)+sizeof(boolean));
  end; {aivfree}

  procedure aivzero;
  begin
    with p do
      ivzero(1,dimen,ivdata);
  end; {aivzero}

  procedure aivenum;
  var
    i: index;
  begin
    with a do
      for i := 1 to dimen do
        ivdata[i] := i;
  end; {aivenum}

  procedure ivenum;
  var
    i: index;
  begin
    v[dim0] := c0;
    for i := dim0+1 to dim1 do
      v[i] := v[i-1] + c;
  end;

  function aivcopy;
  begin
    if (p.dimen<=q.allocdimen) then begin
      ivcopy(1,p.dimen,p.ivdata,q.ivdata);
      q.dimen := p.dimen;
      aivcopy := true;
    end else
      aivcopy := false;
  end; {ivcopy}

  procedure aivfill;
  begin
    with p do
      ivfill(1,dimen,ivdata,c);
  end; {ivfill}

  procedure ivecreflect;
  var
    i: index;
  begin
    if (@x=@y) then
      for i := 0 to (dim1-dim0) div 2 do
        idxswap(x[dim0+i], x[dim1-i])
    else
      for i := dim0 to dim1 do
        y[dim1-i+1] := x[i];
  end;


