(*
FPU i87 implementation of vector operations
(C) Copyright 1997-2000 by Jan Jelowicki, jasj@karnet.ar.wroc.pl

This implements quad-precision vector operations

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...
*)

  { SupNorm := |R| L^\infty  }

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function qvecnormlsup;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX
    MOV     ECX,EAX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + ECX]
    FABS
    FCOM   ST(1)
    FNSTSW  AX
    SAHF
    JAE     @@?3
    FSTP    ST(0)
    JMP     @@?4
  @@?3:
    FSTP    ST(1)
  @@?4:
    SUB     ECX,qFlsize
  @@?2:
    CMP     ECX,0
    JGE     @@?1

  end; {asmsupnorm}

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function qvecnorml2;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + EAX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSQRT
  end; {asml2norm}

{ !! not tested !! }
  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spqVecnorml2;
  assembler;
  asm

    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     esi, [DWORD PTR r]
    MOV     ECX, [DWORD PTR pattern]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ECX+EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [esi + edx] {!qFlsize!}
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,idxsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSQRT

  end; {asmspqVecnorml2}
{ !! not tested !! }

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function qvecnorml1;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + EAX]
    FABS
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asml1norm}

{ !! not tested !! }
  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spqVecnorml1;
  assembler;
  asm

    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     esi, [DWORD PTR r]
    MOV     ECX, [DWORD PTR pattern]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ECX+EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [esi + edx]
    FABS
    FADDP   ST(1),ST(0)
    SUB     EAX,idxsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecnorml1}
{ !! not tested !! }

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,ECX,EDX}
  function qvecnormlp;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX
    MOV     ECX,EAX;

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     vecLpNormExponent;
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + ECX]
    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?4;
    FABS;
    CALL    System._Ln;
    FMUL    ST(0),ST(2)
    CALL    System._Exp;
    FADDP   ST(1),ST(0)
    jmp @@?5
  @@?4:
    FSTP    ST(0)
  @@?5:
    SUB     ECX,qFlsize
  @@?2:
    CMP     ECX,0
    JGE     @@?1

    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?8;
    CALL    System._Ln;
    FLD1;
    FDIV    ST(0),ST(2);
    FMULP   ST(1),ST(0);
    CALL    System._Exp;
  @@?8:
    FSTP;
  end; {asmvecnormlp}


{ !! not tested !! }
  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function qvecdistl1;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     ECX, [DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR y]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FLD     TBYTE PTR [EDX + EAX]
    FSUBP
    FABS
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmdiffl1norm}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function qvecdistl2;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     ECX, [DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR y]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FLD     TBYTE PTR [EDX + EAX]
    FSUBP
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSQRT
  end; {asmdiffl2norm}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EBX,ESI,EDI} {$USES EAX,EDI,ECX,EDX}
  function qvecdistlp;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX
    MOV     EDI,EAX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     ECX, [DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR y]
    ADD     EDX,EAX
    pop eax
    FLD     vecLpNormExponent;
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EDI]
    FLD     TBYTE PTR [EDX + EDI]
    FSUBP
    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?4;
    FABS;
    CALL    System._Ln;
    FMUL    ST(0),ST(2)
    CALL    System._Exp;
    FADDP   ST(1),ST(0)
    JMP     @@?5
  @@?4:
    FSTP    ST(0)
  @@?5:
    SUB     EDI,qFlsize
  @@?2:
    CMP     EDI,0
    JGE     @@?1

    FTST;
    FNSTSW AX;
    SAHF;
    JE @@?8;
    CALL    System._Ln;
    FLD1;
    FDIV    ST(0),ST(2);
    FMULP   ST(1),ST(0);
    CALL    System._Exp;
  @@?8:
    FSTP;
  end; {asmvecdistlp}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EBX,ESI} {$USES EAX,ECX,EDX,EDI}
  function qvecdistlsup;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX
    MOV     ECX,EAX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR x]
    ADD     EDX,EAX
    MOV     EDI, [DWORD PTR y]
    ADD     EDI,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + ECX]
    FLD     TBYTE PTR [EDI + ECX]
    FSUBP
    FABS
    FCOM    ST(1)
    FNSTSW  AX
    SAHF
    JAE     @@?3
    FSTP    ST(0)
    JMP     @@?4
  @@?3:
    FSTP    ST(1)
  @@?4:
    SUB     ECX,qFlsize
  @@?2:
    CMP     ECX,0
    JGE     @@?1

  end; {asmvecdistlsup}
{ !! not tested !! }

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function qvecsum;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + EAX]
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecsum}

{ !! not tested !! }
  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spqVecsum;
  assembler;
  asm

    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     esi, [DWORD PTR r]
    MOV     ECX, [DWORD PTR pattern]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ECX+EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [esi + edx]
    FADDP   ST(1),ST(0)
    SUB     EAX,idxsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecsum}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function qvecdot;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     ECX, [DWORD PTR p]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR q]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FLD     TBYTE PTR [EDX + EAX]
    FMULP
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecdot}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  function spqVecdot;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR p]
    MOV     ebx,[DWORD PTR q]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ebx + edx]
    FLD     TBYTE PTR [ECX + edx]
    FMULP
    FADDP   ST(1),ST(0)
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecdot}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvectimes;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX, [DWORD PTR r]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR p]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR q]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FLD     TBYTE PTR [EDX + EAX]
    FMULP
    FSTP    TBYTE PTR [EBX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvectimes}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVectimes;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR p]
    MOV     ebx,[DWORD PTR q]
    MOV     EDI,[DWORD PTR r]
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ebx + edx]
    FLD     TBYTE PTR [ECX + edx]
    FMULP
    FSTP    TBYTE PTR [EDI + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVectimes}
{ !! not tested !! }

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  function qvecsqr;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR p]
    ADD     EDX,EAX
    pop eax
    FLDZ
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + EAX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecsqr}

{ !! not tested !! }
  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  function spqVecsqr;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR p]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     EDX, DWORD PTR [ESI + EAX]
    DEC     EDX
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ECX + EDX]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecsqr}
{ !! not tested !! }

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure qvecfill;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qflsize
    MUL     EDX

    FLD     TBYTE PTR c

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:

    FLD     ST(0)
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecfill}

{ !! not tested !! }
  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure qvecaddc;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FADD    ST(0),ST(1)
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecaddc}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spqvecaddc;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     esi,[DWORD PTR r]
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [EBX + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ECX + edx]
    FADD    ST(0),ST(1)
    FSTP    TBYTE PTR [esi + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqvecaddc}
{ !! not tested !! }

  {$SAVES EBX,ECX,ESI,EDI} {$USES EAX,EDX}
  procedure qveczero;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qflsize
    MUL     EDX

    FLDZ

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR x]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:

    FLD     ST(0)
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qflsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmqveczero}

{ !! not tested !! }
  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  procedure spqVeczero;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     esi,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    FLDZ
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [esi + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     ST(0)
    FSTP    TBYTE PTR [ECX + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVeczero}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EAX,EBX,ESI} {$USES ECX,EDX,ESI}
  function qveccmpl1;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    INC     EAX;

    MOV     EDX,qFlsize;
    MUL     EDX;
    MOV     ECX,EAX;
    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX,[x];
    ADD     EDX,EAX
    MOV     EDI,[y];
    ADD     EDI,EAX
    pop eax
    FLD     threshold;
    FLDZ
    XOR     EAX,EAX;
  @@?1:
    CMP     ECX,0
    JE      @@?4
  @@?2:
    FCOM    ST(1)
    FNSTSW  AX
    SAHF
    JAE      @@?4
  @@?3:
    SUB     ECX,qFlsize

    FLD     TBYTE PTR [EDX+ECX]
    FLD     TBYTE PTR [EDI+ECX]
    FSUBP
    FABS
    FADDP   ST(1),ST(0)

    JMP     @@?1
  @@?4:
(*
    CMP     ECX,0
    SETE    AL
    FSTP
    FSTP    ST(0)
*)
    FCOMPP
    FNSTSW  AX
    SAHF
    SETBE AL
  end; {asmveccmpl1}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EAX,EBX,ESI} {$USES ECX,EDX,ESI}
  function qveccmpl2;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    INC     EAX;;
    MOV     EDX,qFlsize;
    MUL     EDX;
    MOV     ECX,EAX;
    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX,[x];
    ADD     EDX,EAX
    MOV     EDI,[y];
    ADD     EDI,EAX
    pop eax
    FLD     threshold;
    FMUL    ST(0),ST(0)
    FLDZ
    XOR     EAX,EAX;
  @@?1:
    CMP     ECX,0
    JE      @@?4
  @@?2:
    FCOM   ST(1)
    FNSTSW  AX
    SAHF
    JAE      @@?4
  @@?3:
    SUB     ECX,qFlsize

    FLD     TBYTE PTR [EDX+ECX]
    FLD     TBYTE PTR [EDI+ECX]
    FSUBP
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)

    JMP     @@?1
  @@?4:
(*
    CMP     ECX,0
    SETE    AL
    FSTP
    FSTP    ST(0)
*)
    FCOMPP
    FNSTSW  AX
    SAHF
    SETBE AL
  end; {asmveccmpl2}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EAX,EBX,ESI} {$USES ECX,EDX,ESI}
  function qveccmplsup;
  assembler;
  asm
    MOV     EAX,dim1;
    SUB     EAX,dim0;
    INC     EAX;
    MOV     EDX,qFlsize;
    MUL     EDX;
    MOV     ECX,EAX;
    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX,[x];
    ADD     EDX,EAX
    MOV     EDI,[y];
    ADD     EDI,EAX
    pop eax
    FLD     threshold;
    XOR     EAX,EAX;
  @@?1:
    CMP     ECX,0
    JE      @@?4
  @@?3:
    SUB     ECX,qFlsize

    FLD     TBYTE PTR [EDX+ECX]
    FLD     TBYTE PTR [EDI+ECX]
    FSUBP
    FABS
    FCOMP   ST(1)
    FNSTSW  AX
    SAHF
    JB      @@?1
    MOV     ECX,-1
  @@?4:
    CMP     ECX,0
    SETE    AL
    FSTP    ST(0)
  end; {veccmp}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spqVeccopy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     esi,[DWORD PTR y]
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [EBX + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ECX + edx]
    FSTP    TBYTE PTR [esi + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVeccopy}
{ !! not tested !! }

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure qvecmcopy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EDX, [DWORD PTR x]
    ADD     EDX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EDX + EAX]
    FCHS
    FSTP    TBYTE PTR [ECX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecmcopy}

{ !! not tested !! }
  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spqVecmcopy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     esi,[DWORD PTR y]
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [EBX + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ECX + edx]
    FCHS
    FSTP    TBYTE PTR [esi + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecmcopy}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecadd;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FLD     TBYTE PTR [EBX + EAX]
    FADDP
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmvecadd}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecadd;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FLD     TBYTE PTR [ECX + edx]
    FADDP
    FSTP    TBYTE PTR [ebx + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecadd}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecpadd;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p;
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FLD     TBYTE PTR [EBX + EAX]
    FADDP
    FMUL    ST(0),ST(1)
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecpadd}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecpadd;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FLD     TBYTE PTR [ECX + edx]
    FADDP
    FMUL    ST(0),ST(1)
    FSTP    TBYTE PTR [ebx + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVecpadd}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecsub;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    JMP     @@?2

  @@?1:
    FLD      TBYTE PTR [EBX + EAX]
    FLD      TBYTE PTR [ECX + EAX]
    FSUBP
    FSTP     TBYTE PTR [EDX + EAX]
    SUB      EAX,qFlsize
  @@?2:
    CMP      EAX,0
    JGE      @@?1

  end; {asmvecsub}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecsub;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FLD     TBYTE PTR [ECX + edx]
    FSUBP
    FSTP    TBYTE PTR [ebx + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

  end; {asmspqVecsub}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecpsub;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p;
    JMP     @@?2

  @@?1:
    FLD      TBYTE PTR [EBX + EAX]
    FLD      TBYTE PTR [ECX + EAX]
    FSUBP
    FMUL     ST(0),ST(1)
    FSTP     TBYTE PTR [EDX + EAX]
    SUB      EAX,qFlsize
  @@?2:
    CMP      EAX,0
    JGE      @@?1

    FSTP     ST(0)

  end; {asmvecpsub}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecpsub;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FLD     TBYTE PTR [ECX + edx]
    FSUBP
    FMUL    ST(0),ST(1)
    FSTP    TBYTE PTR [ebx + edx]
    POP     EAX
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVecpsub}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecaddpxy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX,[DWORD PTR y]
    ADD     EBX,EAX
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FMUL    ST(0),ST(1)
    FLD     TBYTE PTR [EBX + EAX]
    FADDP
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecaddpxy}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecaddpxy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FMUL    ST(0),ST(1)
    FLD     TBYTE PTR [ECX + edx]
    FADDP
    FSTP    TBYTE PTR [ebx + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVecaddpxy}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecsubpxy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX,[DWORD PTR y]
    ADD     EBX,EAX
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FMUL    ST(0),ST(1)
    FLD     TBYTE PTR [EBX + EAX]
    FSUBP
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecsubpxy}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecsubpxy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    FLD     TBYTE PTR p
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FMUL    ST(0),ST(1)
    FLD     TBYTE PTR [ECX + edx]
    FSUBP
    FSTP    TBYTE PTR [ebx + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVecsubpxy}
{ !! not tested !! }

  {$SAVES ESI,EDI} {$USES EAX,EBX,ECX,EDX}
  procedure qvecaddpxqy;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     EBX, [DWORD PTR x]
    ADD     EBX,EAX
    MOV     ECX, [DWORD PTR y]
    ADD     ECX,EAX
    MOV     EDX, [DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR p
    FLD     TBYTE PTR q
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [EBX + EAX]
    FMUL    ST(0),ST(2)
    FLD     TBYTE PTR [ECX + EAX]
    FMUL    ST(0),ST(2)
    FADDP   ST(1),ST(0)
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)
    FSTP    ST(0)

  end; {asmvecaddpxqy}

{ !! not tested !! }
  {$SAVES NONE} {$USES EAX,EBX,ECX,EDX,EDI,ESI}
  procedure spqVecaddpxqy;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     ESI,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR y]
    MOV     EDI,[DWORD PTR x]
    MOV     ebx,[DWORD PTR r]
    FLD     TBYTE PTR p
    FLD     TBYTE PTR q
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [ESI + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [EDI + edx]
    FMUL    ST(0),ST(2)
    FLD     TBYTE PTR [ECX + edx]
    FMUL    ST(0),ST(2)
    FADDP   ST(1),ST(0)
    FSTP    TBYTE PTR [ebx + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP
    FSTP    ST(0)

  end; {asmspqVecsubpxy}
{ !! not tested !! }

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  procedure qvecscale;
  assembler;
  asm

    MOV     EAX,dim1;
    SUB     EAX,dim0;
    MOV     EDX,qFlsize
    MUL     EDX

    push eax
    mov eax,dim0
    dec eax
    mov edx,qflsize
    mul edx
    MOV     ECX,[DWORD PTR x]
    ADD     ECX,EAX
    MOV     EDX,[DWORD PTR r]
    ADD     EDX,EAX
    pop eax
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    FLD     TBYTE PTR [ECX + EAX]
    FMUL    ST(0),ST(1)
    FSTP    TBYTE PTR [EDX + EAX]
    SUB     EAX,qFlsize
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmvecscale}

{ !! not tested !! }
  {$SAVES EDI} {$USES EAX,EBX,ECX,EDX,ESI}
  procedure spqVecscale;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     EBX,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR x]
    MOV     esi,[DWORD PTR r]
    FLD     TBYTE PTR a
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [EBX + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     TBYTE PTR [ECX + edx]
    FMUL    ST(0),ST(1)
    FSTP    TBYTE PTR [esi + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVecscale}
{ !! not tested !! }

{ !! not tested !! }
  {$SAVES EBX,EDI} {$USES EAX,ECX,EDX,ESI}
  procedure spqVecfill;
  assembler;
  asm
    MOV     EAX,dim
    DEC     EAX
    MOV     EDX,idxsize
    MUL     EDX

    MOV     esi,[DWORD PTR pattern]
    MOV     ECX,[DWORD PTR r]
    FLD     TBYTE PTR c
    JMP     @@?2

  @@?1:
    MOV     edx, DWORD PTR [esi + EAX]
    DEC     edx
    push eax
    mov eax, qflsize
    mul edx;
    mov edx,eax;
    pop eax;
    FLD     ST(0)
    FSTP    TBYTE PTR [ECX + edx]
    SUB     EAX,IDXSIZE
  @@?2:
    CMP     EAX,0
    JGE     @@?1

    FSTP    ST(0)

  end; {asmspqVecfill}
{ !! not tested !! }


