{
  2x2 vector and matrix operations
  3x3 vector and matrix operations
  386-asm optimised for DOUBLE vectors and DOUBLE scalars

  Tested with fPrint Virtual Pascal 1.1 (asm and pascal codes)
              Borland Pascal 7.0 and FPK (pascal code)

  (c) Copyright 1996-98 by Jan Jeowicki,
      Department of Mathematics, Wrocaw University of Agriculture, Poland
      jasj@karnet.ar.wroc.pl
      www.ar.wroc.pl/~jasj

This is free source code. Please let me know about bugs.
Please do not remove my name from this file.
No guarantee is given etc...

  partially inspired with VMath10 by Wolfgang Lieff (c) 1991
                          Flinders Institute for Atmospheric and Marine Sciences
                          Bedford Park , South Australia 5042
                          mowl@cc.flinders.edu.au
}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2zero;
  assembler;
  asm
    FLDZ
    MOV     EAX,v
    FST     QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2zero}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2copy;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2copy}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2mcopy;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FCHS
    FLD     QWORD PTR [EAX+dflsize]
    FCHS
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2mcopy}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2scale;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR x
    FMUL    ST(1),ST(0)
    FMUL    QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2scale}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2normalto;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FCHS
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FSTP    QWORD PTR [EAX]
    FSTP    QWORD PTR [EAX+dflsize]
  end; {asmv2normalto}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2dot;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,v2
    FMUL    QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX]
    FMULP   ST(2),ST(0)
    FADDP   ST(1),ST(0)
  end; {asmv2dot}

  {$SAVES EBX,EDX,ESI,EDI} {$USES EAX,ECX}
  function v2cross;
  assembler;
  asm
    MOV     ECX,v2
    MOV     EAX,v1
    FLD     QWORD PTR [ECX]
    FMUL    QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [ECX+dflsize]
    FMUL    QWORD PTR [EAX]
    FSUBP   ST(1),ST(0)
  end; {asmv2cross}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2abs;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FMUL    ST(0),ST(0)
    FLD     QWORD PTR [EAX+dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FSQRT
  end; {asmv2abs}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2sqr;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FMUL    ST(0),ST(0)
    FLD     QWORD PTR [EAX+dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
  end; {asmv2sqr}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2absl1;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FABS
    FLD     QWORD PTR [EAX+dflsize]
    FABS
    FADDP   ST(1),ST(0)
  end; {asmv2sqr}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2addpxqy;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR X
    FMUL    ST(1),ST(0)
    FMUL    QWORD PTR [EAX+dflsize]
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR Y
    FMUL    ST(1),ST(0)
    FMUL    QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FADDP   ST(2),ST(0)
    FADDP   ST(2),ST(0)
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2addpxqy}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2padd;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FADDP   ST(2),ST(0);
    FLD     QWORD PTR [EAX+dflsize]
    FADDP   ST(1),ST(0)
    FLD     QWORD PTR X
    FMUL    ST(2),ST(0);
    FMULP   ST(1),ST(0);
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2xadd}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2psub;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FSUBP   ST(2),ST(0);
    FLD     QWORD PTR [EAX+dflsize]
    FSUBP   ST(1),ST(0)
    FLD     QWORD PTR X
    FMUL    ST(2),ST(0);
    FMULP   ST(1),ST(0);
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2xsub}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2addxpy;
  assembler;
  asm
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR X
    FMUL    ST(1),ST(0)
    FMUL    QWORD PTR [EAX+dflsize]
    MOV     EAX,v1
    FADD    QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX]
    MOV     EAX,r
    FADDP   ST(2),ST(0)
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2addpxqy}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function v2add;
  assembler;
  asm
    MOV     ECX,v1
    MOV     EDX,v2
    MOV     EAX,r
    FLD     QWORD PTR [ECX]
    FADD    QWORD PTR [EDX]
    FSTP    QWORD PTR [EAX]
    FLD     QWORD PTR [ECX+dflsize]
    FADD    QWORD PTR [EDX+dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
  end; {asmv2add}

  {$SAVES EBX,EDX,ESI,EDI} {$USES EAX,ECX}
  function v2shift;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR s
    FADD    ST(1),ST(0)
    FADD    QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv2shift}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function v2sub;
  assembler;
  asm
    MOV     ECX,v1
    MOV     EDX,v2
    MOV     EAX,r
    FLD     QWORD PTR [ECX]
    FSUB    QWORD PTR [EDX]
    FSTP    QWORD PTR [EAX]
    FLD     QWORD PTR [ECX+dflsize]
    FSUB    QWORD PTR [EDX+dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
  end; {asmv2sub}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function fltov2;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR x
    FSTP    QWORD PTR [EAX]
    FLD     QWORD PTR y
    FSTP    QWORD PTR [EAX+dflsize]
  end; {asmfltov2}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2rot;
  assembler;
  asm
    MOV     EAX,x
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,y
    FLD     ST(3)
    FMUL    ST(0),ST(2)
    FLD     ST(3)
    FMUL    ST(0),ST(2)
    FADDP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX]

    FCHS
    FMULP   ST(3),ST(0)
    FMULP   ST(1),ST(0)
    FADDP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX+dflsize]
  end; {asmv2rot}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v2unrot;
  assembler;
  asm
    MOV     EAX,x
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,r
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    MOV     EAX,y
    FLD     ST(3)
    FMUL    ST(0),ST(2)
    FLD     ST(3)
    FMUL    ST(0),ST(2)
    FCHS
    FADDP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX]

    FMULP   ST(3),ST(0)
    FMULP   ST(1),ST(0)
    FADDP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX+dflsize]
  end; {asmv2unrot}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3zero;
  assembler;
  asm
    FLDZ
    MOV     EAX,v
    FST     QWORD PTR [EAX+2*dflsize]
    FST     QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3zero}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3copy;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3copy}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3mcopy;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FCHS
    FLD     QWORD PTR [EAX+dflsize]
    FCHS
    FLD     QWORD PTR [EAX+2*dflsize]
    FCHS
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3mcopy}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3scale;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FLD     QWORD PTR x
    FMUL    ST(3),ST(0)
    FMUL    ST(2),ST(0)
    FMULP   ST(1),ST(0)
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3scale}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3dot;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    MOV     EAX,v2
    FMUL    QWORD PTR [EAX+2*dflsize]
    FLD     QWORD PTR [EAX+dflsize]
    FMULP   ST(2),ST(0)
    FADDP   ST(1),ST(0)
    FLD     QWORD PTR [EAX]
    FMULP   ST(2),ST(0)
    FADDP   ST(1),ST(0)
  end; {asmv3dot}

  {$SAVES EBX,EDX,ESI,EDI} {$USES EAX,ECX}
  function v3cross;
  assembler;
  asm
    MOV     ECX,v1
    MOV     EAX,v2
    FLD     QWORD PTR [ECX]
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [ECX+dflsize]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [ECX+2*dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    MOV     EAX,r
    FLD     ST(1)
    FMUL    ST(0),ST(5)
    FLD     ST(1)
    FMUL    ST(0),ST(7)
    FSUBP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX+dflsize]
    FMUL    ST(0),ST(3)
    FLD     ST(2)
    FMUL    ST(0),ST(2)
    FSUBP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX]
    FSTP    ST(0)
    FMUL    ST(0),ST(3)
    FLD     ST(1)
    FMUL    ST(0),ST(3)
    FSUBP   ST(1),ST(0)
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP
    FSTP
    FSTP    ST(0)
  end; {asmv3cross}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3abs;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FMUL    ST(0),ST(0)
    FLD     QWORD PTR [EAX+dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FLD     QWORD PTR [EAX+2*dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FSQRT
  end; {asmv3abs}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3absl1;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FABS
    FLD     QWORD PTR [EAX+dflsize]
    FABS
    FADDP   ST(1),ST(0)
    FLD     QWORD PTR [EAX+2*dflsize]
    FABS
    FADDP   ST(1),ST(0)
  end; {asmv3sqr}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3sqr;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FMUL    ST(0),ST(0)
    FLD     QWORD PTR [EAX+dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
    FLD     QWORD PTR [EAX+2*dflsize]
    FMUL    ST(0),ST(0)
    FADDP   ST(1),ST(0)
  end; {asmv3sqr}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3addpxqy;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FLD     QWORD PTR X
    FMUL    ST(3),ST(0)
    FMUL    ST(2),ST(0)
    FMULP   ST(1),ST(0)
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FLD     QWORD PTR Y
    FMUL    ST(3),ST(0)
    FMUL    ST(2),ST(0)
    FMULP   ST(1),ST(0)
    FADDP   ST(3),ST(0)
    FADDP   ST(3),ST(0)
    FADDP   ST(3),ST(0)
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3addpxqy}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3padd;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FADDP   ST(3),ST(0)
    FADDP   ST(3),ST(0)
    FADDP   ST(3),ST(0)
    FLD     QWORD PTR X
    FMUL    ST(3),ST(0)
    FMUL    ST(2),ST(0)
    FMULP   ST(1),ST(0)
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3xadd}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3psub;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FSUBP   ST(3),ST(0)
    FSUBP   ST(3),ST(0)
    FSUBP   ST(3),ST(0)
    FLD     QWORD PTR X
    FMUL    ST(3),ST(0)
    FMUL    ST(2),ST(0)
    FMULP   ST(1),ST(0)
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3xsub}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function v3addxpy;
  assembler;
  asm
    MOV     EAX,v1
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    MOV     EAX,v2
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FLD     QWORD PTR X
    FMUL    ST(3),ST(0)
    FMUL    ST(2),ST(0)
    FMULP   ST(1),ST(0)
    FADDP   ST(3),ST(0)
    FADDP   ST(3),ST(0)
    FADDP   ST(3),ST(0)
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3addpxqy}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function v3add;
  assembler;
  asm
    MOV     ECX,v1
    MOV     EDX,v2
    MOV     EAX,r
    FLD     QWORD PTR [ECX]
    FADD    QWORD PTR [EDX]
    FSTP    QWORD PTR [EAX]
    FLD     QWORD PTR [ECX+dflsize]
    FADD    QWORD PTR [EDX+dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [ECX+2*dflsize]
    FADD    QWORD PTR [EDX+2*dflsize]
    FSTP    QWORD PTR [EAX+2*dflsize]
  end; {asmv3add}

  {$SAVES EBX,EDX,ESI,EDI} {$USES EAX,ECX}
  function v3shift;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR [EAX]
    FLD     QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [EAX+2*dflsize]
    FLD     QWORD PTR s
    FADD    ST(3),ST(0)
    FADD    ST(2),ST(0)
    FADDP   ST(1),ST(0)
    MOV     EAX,r
    FSTP    QWORD PTR [EAX+2*dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FSTP    QWORD PTR [EAX]
  end; {asmv3shift}

  {$SAVES EBX,ESI,EDI} {$USES EAX,ECX,EDX}
  function v3sub;
  assembler;
  asm
    MOV     ECX,v1
    MOV     EDX,v2
    MOV     EAX,r
    FLD     QWORD PTR [ECX]
    FSUB    QWORD PTR [EDX]
    FSTP    QWORD PTR [EAX]
    FLD     QWORD PTR [ECX+dflsize]
    FSUB    QWORD PTR [EDX+dflsize]
    FSTP    QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR [ECX+2*dflsize]
    FSUB    QWORD PTR [EDX+2*dflsize]
    FSTP    QWORD PTR [EAX+2*dflsize]
  end; {asmv3sub}

  {$SAVES EBX,ECX,EDX,ESI,EDI} {$USES EAX}
  function fltov3;
  assembler;
  asm
    MOV     EAX,v
    FLD     QWORD PTR x
    FSTP    QWORD PTR [EAX]
    FLD     QWORD PTR y
    FSTP    QWORD PTR [EAX+dflsize]
    FLD     QWORD PTR z
    FSTP    QWORD PTR [EAX+2*dflsize]
  end; {asmfltov3}


